/*
 * Decompiled with CFR 0.152.
 */
package saml.client.sp;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.xmlbeans.impl.util.Base64;

public class Util {
    public static HashMap parseMultiValueQueryString(String query) throws UnsupportedEncodingException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        StringTokenizer t = new StringTokenizer(query, "&");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int index = s.indexOf("=");
            String name = s.substring(0, index);
            String value = s.substring(index + 1);
            name = URLDecoder.decode(name, "UTF-8");
            value = URLDecoder.decode(value, "UTF-8");
            if (retval.containsKey(name)) {
                Object o = retval.get(name);
                if (o instanceof String) {
                    String[] values = new String[]{(String)o, value};
                    retval.put(name, values);
                    continue;
                }
                int length = Array.getLength(o);
                String[] values = new String[length + 1];
                System.arraycopy(o, 0, values, 0, length);
                values[length] = value;
                retval.put(name, values);
                continue;
            }
            retval.put(name, value);
        }
        return retval;
    }

    public static HashMap parseQueryString(String query) throws UnsupportedEncodingException {
        HashMap<String, String> retval = new HashMap<String, String>();
        StringTokenizer t = new StringTokenizer(query, "&");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int index = s.indexOf("=");
            String name = null;
            String value = null;
            if (index != -1) {
                name = s.substring(0, index);
                value = s.substring(index + 1);
                name = URLDecoder.decode(name, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            } else {
                name = s;
            }
            if (retval.containsKey(name)) continue;
            retval.put(name, value);
        }
        return retval;
    }

    public static String getRequiredParam(HttpServletRequest request, String param) throws ServletException {
        String result = request.getParameter(param);
        if (result == null) {
            throw new ServletException("Required Parameter " + param + " missing.");
        }
        return result;
    }

    public static String encodeIdentifiers(String[] identifiers) {
        int bufferSize = 0;
        int i = 0;
        while (i < identifiers.length) {
            if (identifiers[i] != null) {
                bufferSize += identifiers[i].length() * 2;
            }
            ++bufferSize;
            ++i;
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            int i2 = 0;
            while (i2 < identifiers.length) {
                if (identifiers[i2] != null) {
                    buffer.put(identifiers[i2].getBytes("UTF-8"));
                }
                buffer.put((byte)0);
                ++i2;
            }
            buffer.flip();
            byte[] combinedBytes = new byte[buffer.limit()];
            buffer.get(combinedBytes);
            return new String(Base64.encode((byte[])combinedBytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] decodeIdentifiers(String encodedinfo) {
        ArrayList<String> resultArray = new ArrayList<String>(10);
        byte[] combinedBytes = Base64.decode((String)encodedinfo).getBytes();
        int lastpos = 0;
        int i = 0;
        while (i < combinedBytes.length) {
            if (combinedBytes[i] == 0) {
                String str = null;
                if (i - lastpos > 0) {
                    str = new String(combinedBytes, lastpos, i - lastpos);
                }
                resultArray.add(str);
                lastpos = i + 1;
            }
            ++i;
        }
        return resultArray.toArray(new String[resultArray.size()]);
    }

    public static String createQueryString(Map params) throws UnsupportedEncodingException {
        StringBuffer qbuf = new StringBuffer(1024);
        boolean first = true;
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!first) {
                qbuf.append("&");
            }
            first = false;
            qbuf.append(key);
            if (value == null) continue;
            qbuf.append("=");
            qbuf.append(URLEncoder.encode(value, "UTF-8"));
        }
        return qbuf.toString();
    }

    public static String getRequiredValue(Map params, String name) {
        String s = (String)params.get(name);
        if (s == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
        return s;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getUrlBase(HttpServletRequest req) throws MalformedURLException {
        URL reqURL = new URL(req.getRequestURL().toString());
        String path = req.getContextPath();
        URL baseUrl = new URL(reqURL.getProtocol(), reqURL.getHost(), reqURL.getPort(), path);
        return baseUrl.toString();
    }
}

