/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.JBossLocalXAException;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.TransactionSynchronizer;
import org.jboss.resource.connectionmanager.TxConnectionManagerMBean;
import org.jboss.tm.LastResource;
import org.jboss.tm.TxUtils;

public class TxConnectionManager
extends BaseConnectionManager2
implements TxConnectionManagerMBean {
    private ObjectName transactionManagerService;
    private String tmName;
    private TransactionManager tm;
    private boolean trackConnectionByTx = false;
    private boolean localTransactions;

    public TxConnectionManager() {
    }

    public TxConnectionManager(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy, TransactionManager tm) {
        super(ccm, poolingStrategy);
        this.tm = tm;
    }

    public ObjectName getTransactionManagerService() {
        return this.transactionManagerService;
    }

    public void setTransactionManagerService(ObjectName transactionManagerService) {
        this.transactionManagerService = transactionManagerService;
    }

    public void setTransactionManager(String tmName) {
        this.tmName = tmName;
    }

    public String getTransactionManager() {
        return this.tmName;
    }

    public TransactionManager getTransactionManagerInstance() {
        return this.tm;
    }

    public void setTransactionManagerInstance(TransactionManager tm) {
        this.tm = tm;
    }

    public boolean isTrackConnectionByTx() {
        return this.trackConnectionByTx;
    }

    public void setTrackConnectionByTx(boolean trackConnectionByTx) {
        this.trackConnectionByTx = trackConnectionByTx;
    }

    public boolean isLocalTransactions() {
        return this.localTransactions;
    }

    public void setLocalTransactions(boolean localTransactions) {
        this.localTransactions = localTransactions;
    }

    protected void startService() throws Exception {
        if (this.transactionManagerService != null) {
            this.tm = (TransactionManager)this.getServer().getAttribute(this.transactionManagerService, "TransactionManager");
        } else {
            this.log.warn((Object)"----------------------------------------------------------");
            this.log.warn((Object)"----------------------------------------------------------");
            this.log.warn((Object)"Please change your datasource setup to use <depends optional-attribute-name\"TransactionManagerService\">jboss:service=TransactionManager</depends>");
            this.log.warn((Object)"instead of <attribute name=\"TransactionManager\">java:/TransactionManager</attribute>");
            this.log.warn((Object)"Better still, use a *-ds.xml file");
            this.log.warn((Object)"----------------------------------------------------------");
            this.log.warn((Object)"----------------------------------------------------------");
            this.tm = (TransactionManager)new InitialContext().lookup(this.tmName);
        }
        super.startService();
    }

    protected void stopService() throws Exception {
        this.tm = null;
        super.stopService();
    }

    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Transaction tx = null;
        try {
            if (this.trackConnectionByTx && this.tm.getStatus() != 6) {
                tx = this.tm.getTransaction();
            }
        }
        catch (Throwable t) {
            TxConnectionManager.rethrowAsResourceException("Couldn't find current tx", t);
        }
        if (this.trace) {
            this.log.trace((Object)("getManagedConnection trackByTx=" + this.trackConnectionByTx + " tx=" + tx));
        }
        return super.getManagedConnection(tx, subject, cri);
    }

    public void transactionStarted(Collection crs) throws SystemException {
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>();
        Iterator i = crs.iterator();
        while (i.hasNext()) {
            ConnectionRecord cr = (ConnectionRecord)i.next();
            ConnectionListener cl = cr.cl;
            if (cls.contains(cl)) continue;
            cls.add(cl);
            cl.enlist();
        }
    }

    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
        try {
            cl.enlist();
        }
        catch (SystemException se) {
            this.log.info((Object)"Could not enlist in transaction on entering meta-aware object!", (Throwable)se);
            throw new ResourceException("Could not enlist in transaction on entering meta-aware object!" + (Object)((Object)se));
        }
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
        Throwable throwable = null;
        try {
            cl.delist();
        }
        catch (Throwable t) {
            throwable = t;
        }
        boolean isFree = cl.isManagedConnectionFree();
        if (this.trace) {
            this.log.trace((Object)("Disconnected isManagedConnectionFree=" + isFree + " cl=" + cl));
        }
        if (isFree) {
            this.returnManagedConnection(cl, false);
        }
        if (throwable != null) {
            TxConnectionManager.rethrowAsResourceException("Could not delist resource, probably a transaction rollback?", throwable);
        }
    }

    public ConnectionListener createConnectionListener(ManagedConnection mc, Object context) throws ResourceException {
        XAResource xaResource = null;
        xaResource = this.localTransactions ? new LocalXAResource(this.log) : mc.getXAResource();
        TxConnectionEventListener cli = new TxConnectionEventListener(mc, this.poolingStrategy, context, this.log, xaResource);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    public boolean isTransactional() {
        return TxUtils.isActive((TransactionManager)this.tm);
    }

    private class LocalXAResource
    implements XAResource,
    LastResource {
        protected Logger log;
        private ConnectionListener cl;
        private boolean warned = false;
        private Xid currentXid;

        public LocalXAResource(Logger log) {
            this.log = log;
        }

        void setConnectionListener(ConnectionListener cl) {
            this.cl = cl;
        }

        public void start(Xid xid, int flags) throws XAException {
            if (TxConnectionManager.this.trace) {
                this.log.trace((Object)("start, xid: " + xid + ", flags: " + flags));
            }
            if (this.currentXid != null && flags == 0) {
                throw new JBossLocalXAException("Trying to start a new tx when old is not complete! old: " + this.currentXid + ", new " + xid + ", flags " + flags);
            }
            if (this.currentXid == null && flags != 0) {
                throw new JBossLocalXAException("Trying to start a new tx with wrong flags!  new " + xid + ", flags " + flags);
            }
            if (this.currentXid == null) {
                try {
                    this.cl.getManagedConnection().getLocalTransaction().begin();
                }
                catch (ResourceException re) {
                    throw new JBossLocalXAException("Error trying to start local tx: ", re);
                }
                catch (Throwable t) {
                    this.log.info((Object)"Throwable trying to start local transaction!", t);
                    throw new JBossLocalXAException("Throwable trying to start local transaction!", t);
                }
                this.currentXid = xid;
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            if (TxConnectionManager.this.trace) {
                this.log.trace((Object)("end on xid: " + xid + " called with flags " + flags));
            }
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (!xid.equals(this.currentXid)) {
                throw new JBossLocalXAException("wrong xid in commit: expected: " + this.currentXid + ", got: " + xid);
            }
            this.currentXid = null;
            try {
                this.cl.getManagedConnection().getLocalTransaction().commit();
            }
            catch (ResourceException re) {
                TxConnectionManager.this.returnManagedConnection(this.cl, true);
                if (TxConnectionManager.this.trace) {
                    this.log.trace((Object)"commit problem: ", (Throwable)re);
                }
                throw new JBossLocalXAException("could not commit local tx", re);
            }
        }

        public void forget(Xid xid) throws XAException {
            throw new JBossLocalXAException("forget not supported in local tx");
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean isSameRM(XAResource xaResource) throws XAException {
            return xaResource == this;
        }

        public int prepare(Xid xid) throws XAException {
            if (!this.warned) {
                this.log.warn((Object)"Prepare called on a local tx. Use of local transactions on a jta transaction with more than one branch may result in inconsistent data in some cases of failure.");
            }
            this.warned = true;
            return 0;
        }

        public Xid[] recover(int flag) throws XAException {
            throw new JBossLocalXAException("no recover with local-tx only resource managers");
        }

        public void rollback(Xid xid) throws XAException {
            if (!xid.equals(this.currentXid)) {
                throw new JBossLocalXAException("wrong xid in rollback: expected: " + this.currentXid + ", got: " + xid);
            }
            this.currentXid = null;
            try {
                this.cl.getManagedConnection().getLocalTransaction().rollback();
            }
            catch (ResourceException re) {
                TxConnectionManager.this.returnManagedConnection(this.cl, true);
                if (TxConnectionManager.this.trace) {
                    this.log.trace((Object)"rollback problem: ", (Throwable)re);
                }
                throw new JBossLocalXAException("could not rollback local tx", re);
            }
        }

        public boolean setTransactionTimeout(int seconds) throws XAException {
            return false;
        }
    }

    protected class TxConnectionEventListener
    extends BaseConnectionManager2.BaseConnectionEventListener {
        protected Logger log;
        protected Transaction currentTx;
        private final XAResource xaResource;

        public TxConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log, XAResource xaResource) throws ResourceException {
            super(mc, mcp, context, log);
            this.log = log;
            this.xaResource = xaResource;
            if (xaResource instanceof LocalXAResource) {
                ((LocalXAResource)xaResource).setConnectionListener(this);
            }
        }

        public void enlist() throws SystemException {
            if (!this.isTrackByTx() && this.currentTx != null) {
                this.log.warn((Object)("in Enlisting tx, illegal state: " + this.currentTx + " ManagedConnection=" + this.getManagedConnection()));
                throw new IllegalStateException("Can't enlist - already a tx!");
            }
            if (TxConnectionManager.this.tm.getStatus() != 6) {
                Transaction newCurrentTx = TxConnectionManager.this.tm.getTransaction();
                if (this.currentTx != null && !this.currentTx.equals(newCurrentTx)) {
                    this.log.warn((Object)("in Enlisting tx, trying to change tx. illegal state: old: " + this.currentTx + ", new: " + newCurrentTx + ", cel: " + this));
                    throw new IllegalStateException("Trying to change Tx in enlist!");
                }
                if (this.currentTx != null) {
                    if (this.trace) {
                        this.log.trace((Object)("currenttx: " + this.currentTx + ", already enlisted for ManagedConnection: " + this.getManagedConnection()));
                    }
                    return;
                }
                this.currentTx = newCurrentTx;
                if (this.trace) {
                    this.log.trace((Object)("enlisting currenttx: " + this.currentTx + ", ManagedConnection: " + this.getManagedConnection() + " trackByTx=" + this.isTrackByTx()));
                }
            }
            if (this.currentTx != null) {
                boolean succeeded = false;
                try {
                    succeeded = this.currentTx.enlistResource(this.getXAResource());
                }
                catch (Throwable t) {
                    this.setTrackByTx(false);
                    throw new SystemException("Could not get XAResource from ManagedConnection!" + t);
                }
                if (!succeeded) {
                    this.setTrackByTx(false);
                    throw new SystemException("enlistResource failed");
                }
                try {
                    TransactionSynchronizer.registerTxRemoverSynchronization(this.currentTx, new TxRemover(this.currentTx, this.isTrackByTx()));
                }
                catch (Throwable t) {
                    this.setTrackByTx(false);
                    throw new SystemException("Could not register synchronization with tx: " + t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delist() throws ResourceException {
            block7: {
                if (this.trace) {
                    this.log.trace((Object)("delisting currenttx: " + this.currentTx + ", ManagedConnection: " + this.getManagedConnection() + " trackByTx=" + this.isTrackByTx()));
                }
                try {
                    if (this.isTrackByTx() || this.currentTx == null) break block7;
                    try {
                        if (this.currentTx.getStatus() != 6 && !this.currentTx.delistResource(this.getXAResource(), 0x2000000)) {
                            throw new ResourceException("Failure to delist resource");
                        }
                    }
                    finally {
                        this.currentTx = null;
                    }
                }
                catch (Throwable t) {
                    BaseConnectionManager2.rethrowAsResourceException("Error in delist!", t);
                }
            }
        }

        protected XAResource getXAResource() {
            return this.xaResource;
        }

        public void connectionClosed(ConnectionEvent ce) {
            if (this.trace) {
                this.log.trace((Object)("connectionClosed called mc=" + this.getManagedConnection()));
            }
            if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
                throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
            }
            try {
                TxConnectionManager.this.getCcm().unregisterConnection(TxConnectionManager.this, ce.getConnectionHandle());
            }
            catch (Throwable t) {
                this.log.info((Object)"throwable from unregister connection", t);
            }
            try {
                TxConnectionManager.this.unregisterAssociation(this, ce.getConnectionHandle());
                boolean isFree = this.isManagedConnectionFree();
                if (this.trace) {
                    this.log.trace((Object)("isManagedConnectionFree=" + isFree + " mc=" + this.getManagedConnection()));
                }
                if (isFree) {
                    this.delist();
                    TxConnectionManager.this.returnManagedConnection(this, false);
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"Error while closing connection handle!", t);
                TxConnectionManager.this.returnManagedConnection(this, true);
            }
        }

        public void localTransactionStarted(ConnectionEvent ce) {
        }

        public void localTransactionCommitted(ConnectionEvent ce) {
        }

        public void localTransactionRolledback(ConnectionEvent ce) {
        }

        public void connectionErrorOccurred(ConnectionEvent ce) {
            this.currentTx = null;
            super.connectionErrorOccurred(ce);
        }

        public boolean isManagedConnectionFree() {
            if (this.isTrackByTx() && this.currentTx != null) {
                return false;
            }
            return super.isManagedConnectionFree();
        }

        private class TxRemover
        implements Synchronization {
            private Transaction tx;
            private boolean wasTrackByTx;

            public TxRemover(Transaction tx, boolean isTrackByTx) {
                this.tx = tx;
                this.wasTrackByTx = isTrackByTx;
            }

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                if (TxConnectionEventListener.this.currentTx == null || !TxConnectionEventListener.this.currentTx.equals(this.tx)) {
                    if (!this.wasTrackByTx) {
                        return;
                    }
                    String message = "afterCompletion called with wrong tx! Expected: " + TxConnectionEventListener.this.currentTx + ", actual: " + this.tx;
                    IllegalStateException e = new IllegalStateException(message);
                    TxConnectionEventListener.this.log.error((Object)"There is something wrong with the pooling?", (Throwable)e);
                }
                TxConnectionEventListener.this.currentTx = null;
                if (this.wasTrackByTx) {
                    TxConnectionEventListener.this.setTrackByTx(false);
                    if (TxConnectionEventListener.this.isManagedConnectionFree()) {
                        TxConnectionManager.this.returnManagedConnection(TxConnectionEventListener.this, false);
                    }
                }
            }
        }
    }
}

