/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ebxml.registry.security;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class PayloadResolver
extends ResourceResolverSpi {
    private MimeMultipart multipart;
    private String id;

    public PayloadResolver(MimeMultipart multipart, String id) {
        this.multipart = multipart;
        this.id = id;
    }

    public boolean engineCanResolve(Attr uriAttr, String baseURI) {
        try {
            String uri = uriAttr.getNodeValue();
            BodyPart payloadPart = this.multipart.getBodyPart("payload2");
            return payloadPart != null;
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public XMLSignatureInput engineResolve(Attr uriAttr, String baseURI) throws ResourceResolverException {
        String uri = uriAttr.getNodeValue();
        try {
            BodyPart payloadPart = this.multipart.getBodyPart("payload2");
            XMLSignatureInput sigInput = new XMLSignatureInput(payloadPart.getInputStream());
            sigInput.setSourceURI(uri);
            sigInput.setMIMEType(payloadPart.getContentType());
            return sigInput;
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new ResourceResolverException(this.id, (Exception)((Object)e), uriAttr, baseURI);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResourceResolverException(this.id, (Exception)e, uriAttr, baseURI);
        }
    }
}

