/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExternalIdentifier;

public class ExternalIdentifierPanel
extends RegistryObjectPanel {
    JTextField schemeText = null;
    JTextField valueText = null;

    public ExternalIdentifierPanel() {
        this.setBorder(BorderFactory.createTitledBorder("ExternalIdentifier Details"));
        JLabel schemeLabel = new JLabel("ClassificationScheme:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(schemeLabel, this.c);
        this.add(schemeLabel);
        this.schemeText = new JTextField();
        this.schemeText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.schemeText, this.c);
        this.add(this.schemeText);
        JButton showSchemeButton = new JButton("Select ClassificationScheme...");
        showSchemeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExternalIdentifierPanel.this.getSelectedScheme();
            }
        });
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(showSchemeButton, this.c);
        this.add(showSchemeButton);
        JLabel valueLabel = new JLabel("Value:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(valueLabel, this.c);
        this.add(valueLabel);
        this.valueText = new JTextField();
        this.valueText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.valueText, this.c);
        this.add(this.valueText);
    }

    private void getSelectedScheme() {
        ConceptsTreeDialog dialog = ConceptsTreeDialog.showSchemes(this, true, true);
        if (dialog.getStatus() == 1) {
            ArrayList selectedObjects = dialog.getSelectedClassificationSchemes();
            int selectionCount = selectedObjects.size();
            if (selectionCount == 0) {
                RegistryBrowser.displayError("Must select a ClassificationScheme in ClassificationScheme dialog");
            } else {
                if (selectionCount > 1) {
                    RegistryBrowser.displayError("Only one ClassificationScheme selection is allowed in ClassificationScheme dialog. Using last selection");
                }
                ExternalIdentifier externalId = (ExternalIdentifier)this.model;
                Object obj = selectedObjects.get(selectionCount - 1);
                try {
                    String schemeName;
                    Object conceptNameStr = null;
                    ClassificationScheme scheme = null;
                    if (obj instanceof ClassificationScheme) {
                        scheme = (ClassificationScheme)obj;
                        externalId.setIdentificationScheme(scheme);
                    }
                    if ((schemeName = RegistryBrowser.getName(scheme)) == null || schemeName.length() == 0) {
                        schemeName = scheme.getKey().getId();
                    }
                    this.schemeText.setText(schemeName);
                }
                catch (JAXRException e) {
                    RegistryBrowser.displayError(e);
                }
            }
        }
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof ExternalIdentifier)) {
            throw new InvalidRequestException("Expecting a ExternalIdentifier. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        ExternalIdentifier externalId = (ExternalIdentifier)obj;
        try {
            if (externalId != null) {
                ClassificationScheme scheme = externalId.getIdentificationScheme();
                if (scheme != null) {
                    String schemeName = RegistryBrowser.getName(scheme);
                    if (schemeName == null || schemeName.length() == 0) {
                        schemeName = scheme.getKey().getId();
                    }
                    this.schemeText.setText(schemeName);
                }
                this.valueText.setText(externalId.getValue());
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            ExternalIdentifier externalId = (ExternalIdentifier)this.model;
            String value = this.valueText.getText();
            externalId.setValue(value);
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        ExternalIdentifier externalId = (ExternalIdentifier)this.model;
        String value = this.valueText.getText();
        if (value == null || value.length() == 0) {
            throw new JAXRException("Error. ExternalIdentifier.value length must have a value");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.schemeText.setText("");
        this.valueText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.valueText.setEditable(editable);
    }
}

