/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ExternalIdentifiersListModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsList;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExternalIdentifier;

public class ExternalIdentifiersList
extends RegistryObjectsList {
    public ExternalIdentifiersList() {
        this(new ExternalIdentifiersListModel());
    }

    public ExternalIdentifiersList(ExternalIdentifiersListModel model) {
        super("ExternalIdentifier", model);
        this.setCellRenderer(new ExternalIdentifierRenderer());
    }

    class ExternalIdentifierRenderer
    extends JLabel
    implements ListCellRenderer {
        public ExternalIdentifierRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            try {
                ExternalIdentifiersListModel model = (ExternalIdentifiersListModel)list.getModel();
                ExternalIdentifier extId = (ExternalIdentifier)model.elementAt(index);
                ClassificationScheme scheme = extId.getIdentificationScheme();
                String schemeName = RegistryBrowser.getName(scheme);
                String keyName = RegistryBrowser.getName(extId);
                String keyValue = extId.getValue();
                String str = schemeName + ":" + keyName + ":" + keyValue;
                this.setText(str);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
            return this;
        }
    }
}

