/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.AdhocQueryPanel;
import com.sun.xml.registry.client.browser.BusinessQueryPanel;
import com.sun.xml.registry.client.browser.DiscoveryPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.conf.bindings.Configuration;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindParamsPanel
extends JPanel {
    private GridBagConstraints c = new GridBagConstraints();
    private JPanel paramEntryParentPanel = null;
    private BusinessQueryPanel businessPanel = null;
    private AdhocQueryPanel adhocPanel = null;
    private CardLayout cardLayout = null;
    private boolean businessQuery = true;
    private DiscoveryPanel discoveryPanel;
    private Log log = LogFactory.getLog(this.getClass());

    public FindParamsPanel(DiscoveryPanel discoveryPanel) throws JAXRException {
        this.discoveryPanel = discoveryPanel;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        JPanel searchTypePanel = this.createSearchTypePanel();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 11;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(searchTypePanel, this.c);
        this.add(searchTypePanel);
        JPanel actionPanel = this.createActionPanel();
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 11;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(searchTypePanel, this.c);
        this.add(actionPanel);
        this.paramEntryParentPanel = this.createParamEntryParentPanel();
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 1;
        this.c.anchor = 11;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.paramEntryParentPanel, this.c);
        this.add(this.paramEntryParentPanel);
    }

    private JPanel createActionPanel() {
        JPanel actionPanel = new JPanel();
        JButton findButton = new JButton("Search");
        actionPanel.add(findButton);
        findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FindParamsPanel.this.discoveryPanel.find();
            }
        });
        JButton clearButton = new JButton("Clear Form");
        actionPanel.add(clearButton);
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    FindParamsPanel.this.discoveryPanel.clear();
                }
                catch (JAXRException e) {
                    RegistryBrowser.displayError(e);
                }
            }
        });
        return actionPanel;
    }

    private JPanel createSearchTypePanel() {
        JPanel searchTypePanel = new JPanel();
        JRadioButton businessButton = new JRadioButton("Business Query");
        businessButton.setMnemonic(66);
        businessButton.setSelected(true);
        businessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindParamsPanel.this.cardLayout.show(FindParamsPanel.this.paramEntryParentPanel, "businessPanel");
                FindParamsPanel.this.businessQuery = true;
            }
        });
        JRadioButton adhocButton = new JRadioButton("Adhoc Query");
        adhocButton.setMnemonic(65);
        adhocButton.setSelected(false);
        adhocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindParamsPanel.this.cardLayout.show(FindParamsPanel.this.paramEntryParentPanel, "adhocPanel");
                FindParamsPanel.this.businessQuery = false;
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(businessButton);
        buttonGroup.add(adhocButton);
        searchTypePanel.add(businessButton);
        searchTypePanel.add(adhocButton);
        return searchTypePanel;
    }

    private JPanel createParamEntryParentPanel() throws JAXRException {
        JPanel paramEntryParentPanel = new JPanel();
        this.cardLayout = new CardLayout();
        paramEntryParentPanel.setLayout(this.cardLayout);
        Configuration cfg = RegistryBrowser.getInstance().getConfiguration();
        this.businessPanel = new BusinessQueryPanel(this, cfg);
        paramEntryParentPanel.add((Component)this.businessPanel, "businessPanel");
        this.adhocPanel = new AdhocQueryPanel(this, cfg);
        paramEntryParentPanel.add((Component)this.adhocPanel, "adhocPanel");
        return paramEntryParentPanel;
    }

    BulkResponse executeQuery() {
        BulkResponse resp = null;
        resp = this.businessQuery ? this.businessPanel.executeQuery() : this.adhocPanel.executeQuery();
        return resp;
    }

    void find() {
        this.discoveryPanel.find();
    }

    public void clear() throws JAXRException {
        this.businessPanel.clear();
        this.adhocPanel.clear();
    }
}

