/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.LocalizedString;

public class LocalizedStringPanel
extends JBPanel {
    JComboBox localeCombo = null;
    JTextField charsetText = null;
    JTextArea valueText = null;
    protected GridBagConstraints c = null;
    protected GridBagLayout gbl = null;

    public LocalizedStringPanel() {
        this.setBorder(BorderFactory.createTitledBorder("LocalizedString Details"));
        this.gbl = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gbl);
        JLabel localeLabel = new JLabel("Locale: ", 2);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(localeLabel, this.c);
        this.add(localeLabel);
        this.localeCombo = new JComboBox();
        this.localeCombo.setModel(new DefaultComboBoxModel<Locale>(Locale.getAvailableLocales()));
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.localeCombo, this.c);
        this.add(this.localeCombo);
        JLabel charsetLabel = new JLabel("Charset: ", 2);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(charsetLabel, this.c);
        this.add(charsetLabel);
        this.charsetText = new JTextField();
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.charsetText, this.c);
        this.add(this.charsetText);
        JLabel valueLabel = new JLabel("Value:", 2);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(valueLabel, this.c);
        this.add(valueLabel);
        this.valueText = new JTextArea();
        this.valueText.setLineWrap(true);
        this.valueText.setRows(2);
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.valueText, this.c);
        this.add(this.valueText);
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof LocalizedString)) {
            throw new InvalidRequestException("Expecting a LocalizedString. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        LocalizedString lString = (LocalizedString)obj;
        try {
            if (lString != null) {
                String lStringValue;
                Locale lStringLocale = lString.getLocale();
                this.localeCombo.setSelectedItem(lStringLocale);
                String lStringCharset = lString.getCharsetName();
                if (lStringCharset != null) {
                    this.charsetText.setText(lStringCharset);
                }
                if ((lStringValue = lString.getValue()) != null) {
                    this.valueText.setText(lStringValue);
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            LocalizedString lString = (LocalizedString)this.model;
            lString.setLocale((Locale)this.localeCombo.getSelectedItem());
            lString.setCharsetName(this.charsetText.getText());
            lString.setValue(this.valueText.getText());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        if (this.localeCombo.getSelectedItem() == null) {
            throw new JAXRException("Error. LocalizedString.locale must not be null");
        }
        if (this.charsetText.getText() == null) {
            throw new JAXRException("Error. LocalizedString.charset must not be null");
        }
        if (this.valueText.getText().length() > 256) {
            throw new JAXRException("Error. LocalizedString.value length must be <= 256");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.localeCombo.setSelectedItem(Locale.getDefault());
        this.charsetText.setText("");
        this.valueText.setText("");
    }
}

