/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.swing.RegistryMappedModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.User;

public class EmailAddressModel
extends RegistryMappedModel {
    public static final String[] EMAIL_TYPES = new String[]{"Office email", "Home email"};
    private final User user;
    private final Map addresses = new HashMap();

    EmailAddressModel(User u) {
        super(EMAIL_TYPES[0]);
        this.user = u;
    }

    public void setAddress(String address) throws JAXRException {
        address = address.trim();
        if (this.addresses.containsKey(this.key)) {
            EmailAddress emailAddress = (EmailAddress)this.addresses.get(this.key);
            emailAddress.setAddress(address);
        } else {
            EmailAddress emailAddress = this.user.getLifeCycleManager().createEmailAddress(address, this.key);
            this.addresses.put(this.key, emailAddress);
            this.user.setEmailAddresses(this.addresses.values());
        }
    }

    public EmailAddress getAddress() {
        EmailAddress address = (EmailAddress)this.addresses.get(this.key);
        return address;
    }

    public void validate() throws JAXRException {
        Collection addressSet = this.addresses.values();
        EmailAddress address = null;
        Iterator i = addressSet.iterator();
        while (i.hasNext()) {
            address = (EmailAddress)i.next();
            String emailAddress = address.getAddress();
            if (emailAddress != null && emailAddress.length() != 0) continue;
            this.addresses.remove(address.getType());
        }
        this.user.setEmailAddresses(this.addresses.values());
        if (this.addresses.isEmpty()) {
            throw new JAXRException("Missing required EmailAddress on User");
        }
    }
}

