/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.registration.EmailAddressModel;
import com.sun.xml.registry.client.browser.swing.MappedDocumentListener;
import com.sun.xml.registry.client.browser.swing.RegistryComboBoxListener;
import com.sun.xml.registry.client.browser.swing.RegistryMappedPanel;
import com.sun.xml.registry.client.browser.swing.TextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.EmailAddress;

public class EmailAddressPanel
extends RegistryMappedPanel {
    private final EmailAddressModel model;
    private final JTextField addressText = new JTextField();

    public EmailAddressPanel(EmailAddressModel email) {
        super(email, "Can not display email address: ");
        this.model = email;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gbl);
        JLabel addressLabel = new JLabel("Email Address:", 2);
        EmailAddressPanel.setConstraints(addressLabel, c, gbl, 0, 0, 1, 0.0, 0, 17);
        this.add(addressLabel);
        this.addressText.getDocument().addDocumentListener(new AddressListener());
        EmailAddressPanel.setConstraints(this.addressText, c, gbl, 0, 1, 1, 0.5, 1, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return EmailAddressPanel.this.addressText;
            }

            public String getText() throws JAXRException {
                EmailAddress address = EmailAddressPanel.this.getEmailAddressModel().getAddress();
                if (address != null) {
                    return address.getAddress();
                }
                return null;
            }
        });
        JLabel typeLabel = new JLabel("Address Type:", 2);
        EmailAddressPanel.setConstraints(typeLabel, c, gbl, 1, 0, 1, 0.0, 0, 17);
        this.add(typeLabel);
        JComboBox<String> typeCombo = new JComboBox<String>(EmailAddressModel.EMAIL_TYPES);
        typeCombo.addActionListener(new EmailTypeListener());
        typeCombo.setEditable(true);
        EmailAddressPanel.setConstraints(typeCombo, c, gbl, 1, 1, 1, 0.5, 2, 17);
        this.add(typeCombo);
    }

    public EmailAddressModel getEmailAddressModel() {
        return this.model;
    }

    class EmailTypeListener
    extends RegistryComboBoxListener {
        EmailTypeListener() {
            super(EmailAddressPanel.this.getEmailAddressModel(), EmailAddressPanel.this.getRegistryMappedPanel());
        }
    }

    class AddressListener
    extends MappedDocumentListener {
        AddressListener() {
            super(EmailAddressPanel.this.getRegistryMappedPanel(), "Can not set email address: ");
        }

        protected void setText(String text) throws JAXRException {
            EmailAddressPanel.this.getEmailAddressModel().setAddress(text);
        }
    }
}

