/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.registration.PostalAddressModel;
import com.sun.xml.registry.client.browser.swing.MappedDocumentListener;
import com.sun.xml.registry.client.browser.swing.RegistryComboBoxListener;
import com.sun.xml.registry.client.browser.swing.RegistryMappedPanel;
import com.sun.xml.registry.client.browser.swing.TextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.PostalAddress;

public class PostalAddressPanel
extends RegistryMappedPanel {
    private final PostalAddressModel model;
    private final JTextField streetNumText = new JTextField();
    private final JTextField streetText = new JTextField();
    private final JTextField cityText = new JTextField();
    private final JTextField stateText = new JTextField();
    private final JTextField postalCodeText = new JTextField();
    private final JTextField countryText = new JTextField();

    PostalAddressPanel(PostalAddressModel address) {
        super(address, "Can not display postal address: ");
        this.model = address;
        this.model.addObserver(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gbl);
        JLabel streetNumLabel = new JLabel("Street Number:", 2);
        PostalAddressPanel.setConstraints(streetNumLabel, c, gbl, 0, 0, 1, 0.0, 0, 17);
        this.add(streetNumLabel);
        this.streetNumText.getDocument().addDocumentListener(new StreetNumListener());
        PostalAddressPanel.setConstraints(this.streetNumText, c, gbl, 0, 1, 1, 0.5, 1, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return PostalAddressPanel.this.streetNumText;
            }

            public String getText() throws JAXRException {
                PostalAddress address = PostalAddressPanel.this.getPostalAddressModel().getAddress();
                if (address != null) {
                    return address.getStreetNumber();
                }
                return null;
            }
        });
        JLabel streetLabel = new JLabel("Street:", 2);
        PostalAddressPanel.setConstraints(streetLabel, c, gbl, 1, 0, 1, 0.0, 0, 17);
        this.add(streetLabel);
        this.streetText.getDocument().addDocumentListener(new StreetListener());
        PostalAddressPanel.setConstraints(this.streetText, c, gbl, 1, 1, 1, 0.5, 2, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return PostalAddressPanel.this.streetText;
            }

            public String getText() throws JAXRException {
                PostalAddress address = PostalAddressPanel.this.getPostalAddressModel().getAddress();
                if (address != null) {
                    return address.getStreet();
                }
                return null;
            }
        });
        JLabel cityLabel = new JLabel("City:", 2);
        PostalAddressPanel.setConstraints(cityLabel, c, gbl, 0, 2, 1, 0.0, 0, 17);
        this.add(cityLabel);
        this.cityText.getDocument().addDocumentListener(new CityListener());
        PostalAddressPanel.setConstraints(this.cityText, c, gbl, 0, 3, 1, 0.5, 1, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return PostalAddressPanel.this.cityText;
            }

            public String getText() throws JAXRException {
                PostalAddress address = PostalAddressPanel.this.getPostalAddressModel().getAddress();
                if (address != null) {
                    return address.getCity();
                }
                return null;
            }
        });
        JLabel stateLabel = new JLabel("State/Province:", 2);
        PostalAddressPanel.setConstraints(stateLabel, c, gbl, 1, 2, 1, 0.0, 0, 17);
        this.add(stateLabel);
        this.stateText.getDocument().addDocumentListener(new StateListener());
        PostalAddressPanel.setConstraints(this.stateText, c, gbl, 1, 3, 1, 0.5, 2, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return PostalAddressPanel.this.stateText;
            }

            public String getText() throws JAXRException {
                PostalAddress address = PostalAddressPanel.this.getPostalAddressModel().getAddress();
                if (address != null) {
                    return address.getStateOrProvince();
                }
                return null;
            }
        });
        JLabel postalCodeLabel = new JLabel("Postal Code:", 2);
        PostalAddressPanel.setConstraints(postalCodeLabel, c, gbl, 0, 4, 1, 0.0, 2, 17);
        this.add(postalCodeLabel);
        this.postalCodeText.getDocument().addDocumentListener(new PostalCodeListener());
        PostalAddressPanel.setConstraints(this.postalCodeText, c, gbl, 0, 5, 1, 0.5, 1, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return PostalAddressPanel.this.postalCodeText;
            }

            public String getText() throws JAXRException {
                PostalAddress address = PostalAddressPanel.this.getPostalAddressModel().getAddress();
                if (address != null) {
                    return address.getPostalCode();
                }
                return null;
            }
        });
        JLabel countryLabel = new JLabel("Country:", 2);
        PostalAddressPanel.setConstraints(countryLabel, c, gbl, 1, 4, 1, 0.0, 1, 17);
        this.add(countryLabel);
        this.countryText.getDocument().addDocumentListener(new CountryListener());
        PostalAddressPanel.setConstraints(this.countryText, c, gbl, 1, 5, 1, 0.5, 2, 17);
        this.addTextField(new TextField(){

            public JTextField getTextField() {
                return PostalAddressPanel.this.countryText;
            }

            public String getText() throws JAXRException {
                PostalAddress address = PostalAddressPanel.this.getPostalAddressModel().getAddress();
                if (address != null) {
                    return address.getCountry();
                }
                return null;
            }
        });
        JLabel typeLabel = new JLabel("Address Type:", 2);
        PostalAddressPanel.setConstraints(typeLabel, c, gbl, 0, 6, 1, 0.0, 0, 17);
        this.add(typeLabel);
        JComboBox<String> typeCombo = new JComboBox<String>(PostalAddressModel.ADDRESS_TYPES);
        typeCombo.setEditable(true);
        typeCombo.addActionListener(new AddressTypeListener());
        PostalAddressPanel.setConstraints(typeCombo, c, gbl, 0, 7, 1, 0.5, 0, 17);
        this.add(typeCombo);
        JLabel postalSchemeLabel = new JLabel("Postal Address Scheme:", 2);
        RegistryMappedPanel.setConstraints(postalSchemeLabel, c, gbl, 1, 6, 1, 0.0, 0, 17);
        this.add(postalSchemeLabel);
    }

    public PostalAddressModel getPostalAddressModel() {
        return this.model;
    }

    class AddressTypeListener
    extends RegistryComboBoxListener {
        AddressTypeListener() {
            super(PostalAddressPanel.this.getPostalAddressModel(), PostalAddressPanel.this.getRegistryMappedPanel());
        }
    }

    class CountryListener
    extends MappedDocumentListener {
        public CountryListener() {
            super(PostalAddressPanel.this.getRegistryMappedPanel(), "Could not set country: ");
        }

        protected void setText(String text) throws JAXRException {
            PostalAddressPanel.this.getPostalAddressModel().setCountry(text);
        }
    }

    class PostalCodeListener
    extends MappedDocumentListener {
        public PostalCodeListener() {
            super(PostalAddressPanel.this.getRegistryMappedPanel(), "Could not set postal code: ");
        }

        protected void setText(String text) throws JAXRException {
            PostalAddressPanel.this.getPostalAddressModel().setPostalCode(text);
        }
    }

    class StateListener
    extends MappedDocumentListener {
        public StateListener() {
            super(PostalAddressPanel.this.getRegistryMappedPanel(), "Could not set state: ");
        }

        protected void setText(String text) throws JAXRException {
            PostalAddressPanel.this.getPostalAddressModel().setState(text);
        }
    }

    class CityListener
    extends MappedDocumentListener {
        public CityListener() {
            super(PostalAddressPanel.this.getRegistryMappedPanel(), "Could not set city: ");
        }

        protected void setText(String text) throws JAXRException {
            PostalAddressPanel.this.getPostalAddressModel().setCity(text);
        }
    }

    class StreetListener
    extends MappedDocumentListener {
        public StreetListener() {
            super(PostalAddressPanel.this.getRegistryMappedPanel(), "Could not set street: ");
        }

        protected void setText(String text) throws JAXRException {
            PostalAddressPanel.this.getPostalAddressModel().setStreet(text);
        }
    }

    class StreetNumListener
    extends MappedDocumentListener {
        public StreetNumListener() {
            super(PostalAddressPanel.this.getRegistryMappedPanel(), "Could not set street number: ");
        }

        protected void setText(String text) throws JAXRException {
            PostalAddressPanel.this.getPostalAddressModel().setStreetNum(text);
        }
    }
}

