/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.registration.EmailAddressModel;
import com.sun.xml.registry.client.browser.registration.PersonNameModel;
import com.sun.xml.registry.client.browser.registration.PostalAddressModel;
import com.sun.xml.registry.client.browser.registration.TelephoneNumberModel;
import com.sun.xml.registry.client.browser.swing.Model;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.User;

public class UserModel
implements Model {
    private final User user;
    private final PersonNameModel personName;
    private final EmailAddressModel emailAddress;
    private final PostalAddressModel postalAddress;
    private final TelephoneNumberModel phoneNumber;
    private String alias = null;
    private char[] keyPassword = null;
    private char[] storePassword = null;

    public UserModel(User u) throws JAXRException {
        this.user = u;
        this.personName = new PersonNameModel(u);
        this.emailAddress = new EmailAddressModel(u);
        this.postalAddress = new PostalAddressModel(u);
        this.phoneNumber = new TelephoneNumberModel(u);
        this.storePassword = ProviderProperties.getInstance().getProperty("jaxr-ebxml.security.storepass").toCharArray();
    }

    public User getUser() {
        return this.user;
    }

    public void setAlias(String text) {
        this.alias = text.trim();
    }

    public void setKeyPassword(char[] text) {
        this.keyPassword = text;
    }

    public void setStorePassword(char[] text) {
        this.storePassword = text;
    }

    public String getAlias() {
        return this.alias;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public char[] getStorePassword() {
        return this.storePassword;
    }

    public PersonNameModel getPersonNameModel() {
        return this.personName;
    }

    public EmailAddressModel getEmailAddressModel() {
        return this.emailAddress;
    }

    public PostalAddressModel getPostalAddressModel() {
        return this.postalAddress;
    }

    public TelephoneNumberModel getTelephoneNumberModel() {
        return this.phoneNumber;
    }

    public void validate() throws JAXRException {
        this.personName.validate();
        this.emailAddress.validate();
        this.postalAddress.validate();
        this.phoneNumber.validate();
        InternationalStringImpl roName = (InternationalStringImpl)this.user.getName();
        if (roName == null || roName.getClosestValue() == null || roName.getClosestValue().trim().length() == 0) {
            String name = this.user.getPersonName().getFullName();
            roName = (InternationalStringImpl)this.user.getLifeCycleManager().createInternationalString(name);
            this.user.setName(roName);
        }
        if (this.alias == null || this.alias.length() < 3) {
            throw new JAXRException("Keystore Alias must be at least 3 characters");
        }
        if (this.keyPassword == null || this.keyPassword.length < 6) {
            throw new JAXRException("Private Key Password must be at least 6 characters");
        }
        if (this.storePassword == null || this.storePassword.length < 6) {
            throw new JAXRException("Key Store password must be at least 6 characters");
        }
    }
}

