/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.xml.registry.ebxml.BulkResponseImpl;
import com.sun.xml.registry.ebxml.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.DeclarativeQueryManagerImpl;
import com.sun.xml.registry.ebxml.QueryManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.util.QueryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.User;

public class BusinessQueryManagerImpl
extends QueryManagerImpl
implements BusinessQueryManager {
    private static final String WHERE_KEYWORD = "WHERE";
    private static final String PRIMARY_TABLE_NAME = "ptn";
    QueryUtil qu = QueryUtil.getInstance();
    private static HashMap schemeNameToIdMap = new HashMap();

    BusinessQueryManagerImpl(RegistryServiceImpl regService, BusinessLifeCycleManagerImpl lcm) throws JAXRException {
        super(regService, lcm, (DeclarativeQueryManagerImpl)regService.getDeclarativeQueryManager());
    }

    public BulkResponse findAssociations(Collection findQualifiers, String sourceObjectId, String targetObjectId, Collection associationTypes) throws JAXRException {
        String queryStr = "SELECT * FROM Association WHERE ";
        String andStr = "";
        if (sourceObjectId != null) {
            queryStr = queryStr + " (sourceObject = '" + sourceObjectId + "') ";
            andStr = " AND ";
        }
        if (targetObjectId != null) {
            queryStr = queryStr + andStr + " (targetObject = '" + targetObjectId + "') ";
            andStr = " AND ";
        }
        if (associationTypes != null) {
            // empty if block
        }
        Query query = this.dqm.createQuery(0, queryStr);
        BulkResponse resp = this.dqm.executeQuery(query);
        return resp;
    }

    public BulkResponse findCallerAssociations(Collection findQualifiers, Boolean confirmedByCaller, Boolean confirmedByOtherParty, Collection associationTypes) throws JAXRException {
        if (confirmedByCaller == null && confirmedByOtherParty == null) {
            return new BulkResponseImpl();
        }
        User user = this.getCallersUser();
        String userId = user.getKey().getId();
        String qs = "SELECT * FROM Association a, AuditableEvent e WHERE e.user = '" + userId + "' AND e.eventType = 'Created'";
        if (confirmedByCaller != null) {
            String confirmedByCallerStr = confirmedByCaller != false ? "'T'" : "'F'";
            qs = qs + " AND (e.registryObject = a.sourceObject AND a.isConfirmedBySourceOwner = " + confirmedByCallerStr + " OR e.registryObject = a.targetObject AND " + "a.isConfirmedByTargetOwner = " + confirmedByCallerStr + ")";
        }
        if (confirmedByOtherParty != null) {
            String confirmedByOtherStr = confirmedByOtherParty != false ? "'T'" : "'F'";
            qs = qs + " AND (e.registryObject = a.sourceObject AND a.isConfirmedByTargetOwner = " + confirmedByOtherStr + " OR e.registryObject = a.targetObject AND " + "a.isConfirmedBySourceOwner = " + confirmedByOtherStr + ")";
        }
        Query query = this.dqm.createQuery(0, qs);
        return this.dqm.executeQuery(query);
    }

    public BulkResponse findObjects(String objectType, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        if (objectType.equals("Concept")) {
            objectType = "ClassificationNode";
        }
        Query query = this.createQueryByName(findQualifiers, objectType, namePatterns);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    public BulkResponse findOrganizations(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        Query query = this.createQueryByName(findQualifiers, "Organization", namePatterns);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    public BulkResponse findServices(Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications) throws JAXRException {
        Query query = this.createQueryByName(findQualifiers, "Service", namePatterns);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    public BulkResponse findServiceBindings(Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
        Query query = this.createQueryByName(findQualifiers, "ServiceBinding", null);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    public BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        Query query = this.createQueryByName(findQualifiers, "ClassificationScheme", namePatterns);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    public ClassificationScheme findClassificationSchemeByName(Collection findQualifiers, String namePattern) throws JAXRException {
        ArrayList<String> namePatterns = new ArrayList<String>();
        namePatterns.add(namePattern);
        Query query = this.createQueryByName(findQualifiers, "ClassificationScheme", namePatterns);
        BulkResponse br = this.dqm.executeQuery(query);
        Iterator i = br.getCollection().iterator();
        ClassificationScheme cs = null;
        if (i.hasNext()) {
            cs = (ClassificationScheme)i.next();
        }
        if (i.hasNext()) {
            throw new InvalidRequestException("Error: findClassificationSchemeByName call cannot match more than one ClassificationScheme");
        }
        return cs;
    }

    public BulkResponse findConcepts(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        Query query = this.createQueryByName(findQualifiers, "ClassificationNode", namePatterns);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    public Concept findConceptByPath(String path) throws JAXRException {
        path = this.fixConceptPathForEbXML(path);
        String likeOrEqual = "=";
        if (path.indexOf(37) != -1) {
            likeOrEqual = "LIKE";
        }
        Query query = this.dqm.createQuery(0, "SELECT * from ClassificationNode WHERE path " + likeOrEqual + " '" + path + "'");
        BulkResponse resp = this.dqm.executeQuery(query);
        return (Concept)((BulkResponseImpl)resp).getRegistryObject();
    }

    private String fixConceptPathForEbXML(String path) {
        String schemeId;
        String fistElem;
        String newPath = path;
        StringTokenizer st = new StringTokenizer(path, "/");
        int cnt = st.countTokens();
        if (cnt == 2 && !(fistElem = st.nextToken()).startsWith("urn:") && (schemeId = (String)schemeNameToIdMap.get(fistElem)) != null) {
            String value = st.nextToken();
            newPath = "/" + schemeId + "%/" + value;
        }
        return newPath;
    }

    public Collection findConceptsByPath(String path) throws JAXRException {
        String likeOrEqual = "=";
        if (path.indexOf(37) != -1) {
            likeOrEqual = "LIKE";
        }
        Query query = this.dqm.createQuery(0, "SELECT * from ClassificationNode WHERE path " + likeOrEqual + " '" + path + "'");
        BulkResponse resp = this.dqm.executeQuery(query);
        return resp.getCollection();
    }

    public BulkResponse findRegistryPackages(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        Query query = this.createQueryByName(findQualifiers, "RegistryPackage", namePatterns);
        query = this.addClassifications(query, classifications);
        return this.dqm.executeQuery(query);
    }

    private static String namePatternsToLikeExpr(Collection namePatterns, String term, boolean caseSensitive) {
        Object[] namesArray;
        if (namePatterns == null || namePatterns.size() == 0) {
            return null;
        }
        if (namePatterns.size() == 1 && (namesArray = namePatterns.toArray())[0].equals("%")) {
            return null;
        }
        Iterator i = namePatterns.iterator();
        StringBuffer result = new StringBuffer("(" + BusinessQueryManagerImpl.caseSensitise(term, caseSensitive) + " LIKE " + BusinessQueryManagerImpl.caseSensitise("'" + (String)i.next() + "'", caseSensitive));
        while (i.hasNext()) {
            result.append(" OR " + BusinessQueryManagerImpl.caseSensitise(term, caseSensitive) + " LIKE " + BusinessQueryManagerImpl.caseSensitise("'" + (String)i.next() + "'", caseSensitive));
        }
        return result.append(")").toString();
    }

    public static String caseSensitise(String term, boolean caseSensitive) {
        String newTerm = term;
        if (!caseSensitive) {
            newTerm = "UPPER(" + term + ")";
        }
        return newTerm;
    }

    private static String classificationToConceptId(Object obj) throws JAXRException {
        if (!(obj instanceof Classification)) {
            throw new UnexpectedObjectException("Expected Collection object type to be Classification");
        }
        Classification cl = (Classification)obj;
        if (cl.isExternal()) {
            throw new JAXRException("External classification qualifiers not yet supported");
        }
        Concept concept = cl.getConcept();
        if (concept == null) {
            throw new JAXRException("Concept of internal Classification is null");
        }
        return concept.getKey().getId();
    }

    private Query createQueryByName(Collection findQualifiers, String tableName, Collection namePatterns) throws JAXRException {
        boolean caseSensitive = false;
        if (findQualifiers != null && findQualifiers.contains("caseSensitiveMatch")) {
            caseSensitive = true;
        }
        StringBuffer qs = new StringBuffer("SELECT * FROM " + tableName + " " + PRIMARY_TABLE_NAME);
        String likeExpr = BusinessQueryManagerImpl.namePatternsToLikeExpr(namePatterns, "n.value", caseSensitive);
        if (likeExpr != null) {
            qs.append(", Name n WHERE " + likeExpr + " AND n.parent = " + PRIMARY_TABLE_NAME + ".id");
        }
        if (findQualifiers != null) {
            if (findQualifiers.contains("sortByNameAsc")) {
                qs.append("  ORDER BY n.value ASC");
            } else if (findQualifiers.contains("sortByNameDesc")) {
                qs.append("  ORDER BY n.value DESC");
            }
        }
        return this.dqm.createQuery(0, qs.toString());
    }

    private Query addClassifications(Query query, Collection classifications) throws JAXRException {
        String q = ((Object)query).toString();
        StringBuffer qs = new StringBuffer(q);
        String clExpr = this.qu.classificationsToPred(classifications, "ptn.id");
        if (clExpr != null) {
            if (q.indexOf(WHERE_KEYWORD) != -1) {
                qs.append(" AND ");
            } else {
                qs.append(" WHERE ");
            }
            qs.append(clExpr);
        }
        return this.dqm.createQuery(0, qs.toString());
    }

    static {
        schemeNameToIdMap.put("ObjectType", "urn:uuid:3188a449-18ac-41fb-be9f-99a1adca02cb");
        schemeNameToIdMap.put("PhoneType", "urn:uuid:de95a42e-a0e3-40a3-abcc-ee6d88492639");
        schemeNameToIdMap.put("AssociationType", "urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d");
        schemeNameToIdMap.put("URLType", "urn:uuid:7817755e-8842-44b2-84f4-bf8a765619be");
        schemeNameToIdMap.put("PostalAddressAttributes", "ClassScheme");
    }
}

