/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.xml.registry.ebxml.ConnectionFactoryImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.jaas.LoginModuleManager;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.Connection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionImpl
implements Connection {
    private final Log log = LogFactory.getLog(this.getClass());
    private ConnectionFactoryImpl factory = null;
    private RegistryServiceImpl service = null;
    private String queryManagerURL;
    private String lifeCycleManagerURL;
    private X500PrivateCredential x500Cred;
    private boolean closed = false;
    private boolean synchronous = true;
    private CallbackHandler handler = null;
    private LoginModuleManager loginModuleMgr = null;
    private PasswordAuthentication pwdauth = null;

    ConnectionImpl(ConnectionFactoryImpl factory) throws JAXRException {
        this.factory = factory;
        Properties props = factory.getProperties();
        this.queryManagerURL = props.getProperty("javax.xml.registry.queryManagerURL");
        if (this.queryManagerURL == null) {
            throw new InvalidRequestException("Missing javax.xml.registry.queryManagerURL");
        }
        this.lifeCycleManagerURL = props.getProperty("javax.xml.registry.lifeCycleManagerURL");
        this.loginModuleMgr = new LoginModuleManager();
    }

    public RegistryService getRegistryService() throws JAXRException {
        if (this.service == null) {
            this.service = new RegistryServiceImpl(this);
        }
        return this.service;
    }

    public void close() throws JAXRException {
        this.closed = true;
    }

    public boolean isClosed() throws JAXRException {
        return this.closed;
    }

    public boolean isSynchronous() throws JAXRException {
        return this.synchronous;
    }

    public void setSynchronous(boolean sync) throws JAXRException {
        this.synchronous = sync;
    }

    public void setCredentials(Set credentials) throws JAXRException {
        Iterator it = credentials.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof X500PrivateCredential) {
                this.x500Cred = (X500PrivateCredential)obj;
                return;
            }
            if (!(obj instanceof PasswordAuthentication)) continue;
            this.pwdauth = (PasswordAuthentication)obj;
            return;
        }
        throw new JAXRException("No instance of X500PrivateCredential found");
    }

    public Set getCredentials() throws JAXRException {
        HashSet<Object> ret = new HashSet<Object>();
        if (this.x500Cred != null) {
            ret.add(this.x500Cred);
        }
        if (this.pwdauth != null) {
            ret.add(this.pwdauth);
        }
        return ret;
    }

    X500PrivateCredential getX500PrivateCredential() {
        if (this.x500Cred == null) {
            try {
                this.authenticate();
            }
            catch (JAXRException e) {
                this.log.error((Object)e);
            }
        }
        return this.x500Cred;
    }

    String getQueryManagerURL() {
        return this.queryManagerURL;
    }

    String getLifeCycleManagerURL() {
        return this.lifeCycleManagerURL;
    }

    public ConnectionFactoryImpl getConnectionFactory() {
        return this.factory;
    }

    public LoginModuleManager getLoginModuleManager() {
        return this.loginModuleMgr;
    }

    public CallbackHandler getCallbackHandler() throws JAXRException {
        if (this.handler == null) {
            this.handler = this.loginModuleMgr.getCallbackHandler();
        }
        return this.handler;
    }

    public void setCallbackHandler(CallbackHandler handler) {
        this.loginModuleMgr.setDefaultCallbackHandler(handler);
    }

    public boolean isAuthenticated() throws JAXRException {
        boolean authenticated = false;
        if (this.x500Cred != null) {
            authenticated = true;
        }
        return authenticated;
    }

    public void authenticate() throws JAXRException {
        LoginContext lc = null;
        try {
            this.loginModuleMgr.createLoginConfigFile();
            String applicationName = this.loginModuleMgr.getApplicationName();
            this.handler = this.loginModuleMgr.getCallbackHandler();
            lc = new LoginContext(applicationName, this.handler);
            lc.login();
            Subject subject = lc.getSubject();
            Set<Object> privateCredentials = subject.getPrivateCredentials();
            this.setCredentials(privateCredentials);
            this.log.info((Object)"Set credentials on connection.");
        }
        catch (LoginException le) {
            String msg = le.getMessage();
            if (msg != null && !msg.equalsIgnoreCase("Login cancelled")) {
                throw new JAXRException(le);
            }
        }
        catch (SecurityException se) {
            throw new JAXRException(se);
        }
    }

    public void logoff() throws JAXRException {
        boolean authenticated = this.isAuthenticated();
        if (authenticated) {
            this.x500Cred = null;
        }
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.pwdauth;
    }
}

