/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.infomodel.RegistryObject;

public class ObjectCache {
    private RegistryServiceImpl service = null;
    private HashMap idToReferenceMap = null;

    private ObjectCache() {
    }

    public ObjectCache(RegistryServiceImpl service) {
        this.service = service;
        this.idToReferenceMap = new HashMap(1024);
    }

    public Reference getReference(String id, String objectType) throws JAXRException {
        Reference ref = (Reference)this.idToReferenceMap.get(id);
        if (ref == null || ref.get() == null) {
            DeclarativeQueryManager dqm = this.service.getDeclarativeQueryManager();
            String ebxmlObjType = this.service.mapJAXRNameToEbXMLName(objectType);
            Query query = dqm.createQuery(0, "SELECT id FROM " + ebxmlObjType + " WHERE id='" + id + "'");
            dqm.executeQuery(query);
            ref = (Reference)this.idToReferenceMap.get(id);
        }
        return ref;
    }

    private void putReference(String id, Reference ref) {
        this.idToReferenceMap.put(id, ref);
    }

    public void putRegistryObject(RegistryObject ro) throws JAXRException {
        this.putReference(ro.getKey().getId(), new SoftReference<RegistryObject>(ro));
    }
}

