/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.BusinessQueryManagerImpl;
import com.sun.xml.registry.ebxml.DeclarativeQueryManagerImpl;
import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.AssociationImpl;
import com.sun.xml.registry.ebxml.infomodel.AuditableEventImpl;
import com.sun.xml.registry.ebxml.infomodel.ClassificationImpl;
import com.sun.xml.registry.ebxml.infomodel.ExtensibleObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.infomodel.KeyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.Query;
import javax.xml.registry.RegistryException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.User;
import org.apache.commons.logging.Log;
import org.oasis.ebxml.registry.bindings.rim.Classification;
import org.oasis.ebxml.registry.bindings.rim.Description;
import org.oasis.ebxml.registry.bindings.rim.ExternalIdentifier;
import org.oasis.ebxml.registry.bindings.rim.Name;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;

public abstract class RegistryObjectImpl
extends ExtensibleObjectImpl
implements RegistryObject {
    private Key key = null;
    private InternationalString description = null;
    protected InternationalString name = null;
    protected String objectTypeStr;
    protected Concept objectType;
    protected Collection classifications = new ArrayList();
    protected Collection externalIds = new ArrayList();
    protected Collection associations = null;
    protected HashSet externalLinks = null;
    protected Collection packages = null;
    protected Collection auditTrail = null;
    protected DeclarativeQueryManagerImpl dqm = null;
    protected BusinessQueryManagerImpl bqm = null;
    private Organization org = null;

    RegistryObjectImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
        this.dqm = (DeclarativeQueryManagerImpl)lcm.getRegistryService().getDeclarativeQueryManager();
        this.bqm = (BusinessQueryManagerImpl)lcm.getRegistryService().getBusinessQueryManager();
        this.key = lcm.createKey();
        String str = this.getClass().getName();
        this.objectTypeStr = str.substring(str.lastIndexOf(46) + 1, str.length() - 4);
    }

    RegistryObjectImpl(LifeCycleManagerImpl lcm, RegistryObjectType ebObject) throws JAXRException {
        super(lcm, ebObject);
        this.dqm = (DeclarativeQueryManagerImpl)lcm.getRegistryService().getDeclarativeQueryManager();
        this.bqm = (BusinessQueryManagerImpl)lcm.getRegistryService().getBusinessQueryManager();
        this.key = new KeyImpl(lcm);
        this.key.setId(ebObject.getId());
        if (ebObject.getName() != null) {
            this.name = new InternationalStringImpl(lcm, ebObject.getName());
        }
        if (ebObject.getDescription() != null) {
            this.description = new InternationalStringImpl(lcm, ebObject.getDescription());
        }
        Classification[] ebClasses = ebObject.getClassification();
        for (int i = 0; i < ebClasses.length; ++i) {
            this.internalAddClassification(new ClassificationImpl(lcm, ebClasses[i], this));
        }
        ExternalIdentifier[] extIds = ebObject.getExternalIdentifier();
        for (int i = 0; i < extIds.length; ++i) {
            this.internalAddExternalIdentifier(new ExternalIdentifierImpl(lcm, extIds[i], this));
        }
        String ebObjectType = ebObject.getObjectType();
        this.objectTypeStr = ebObjectType == null ? "Unknown" : ebObjectType;
        ebObject.getAccessControlPolicy();
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified) {
            this.lcm.addModifiedObject(this);
        } else {
            this.lcm.removeModifiedObject(this);
        }
    }

    public Concept getObjectType() throws JAXRException {
        if (this.objectType == null) {
            RegistryObject ro;
            if (this.objectTypeStr.startsWith("urn:uuid:") && (ro = this.dqm.getRegistryObject(this.objectTypeStr, "Concept")) instanceof Concept) {
                this.objectType = (Concept)ro;
            }
            if (this.objectType == null) {
                String jaxrInterfaceName = this.getClass().getName();
                if ((jaxrInterfaceName = jaxrInterfaceName.substring(jaxrInterfaceName.lastIndexOf(".") + 1)).endsWith("Impl")) {
                    jaxrInterfaceName = jaxrInterfaceName.substring(0, jaxrInterfaceName.length() - 4);
                }
                this.objectType = (Concept)this.lcm.getObjectTypesMap().get(jaxrInterfaceName);
            }
        }
        return this.objectType;
    }

    public abstract String toXML() throws JAXRException;

    public Key getKey() throws JAXRException {
        return this.key;
    }

    public String getId() throws JAXRException {
        return this.key.getId();
    }

    public InternationalString getDescription() throws JAXRException {
        if (this.description == null) {
            this.description = this.lcm.createInternationalString("");
        }
        return this.description;
    }

    public void setDescription(InternationalString desc) throws JAXRException {
        this.description = desc;
        this.setModified(true);
    }

    public InternationalString getName() throws JAXRException {
        if (this.name == null) {
            this.name = this.lcm.createInternationalString("");
        }
        return this.name;
    }

    public void setName(InternationalString name) throws JAXRException {
        this.name = name;
        this.setModified(true);
    }

    public void setKey(Key key) throws JAXRException {
        this.key = key;
        this.setModified(true);
    }

    private void internalAddClassification(javax.xml.registry.infomodel.Classification c) throws JAXRException {
        this.getClassifications().add(c);
        c.setClassifiedObject(this);
    }

    public void addClassification(javax.xml.registry.infomodel.Classification c) throws JAXRException {
        this.internalAddClassification(c);
        this.setModified(true);
    }

    public void addClassifications(Collection classifications) throws JAXRException {
        Iterator iter = classifications.iterator();
        while (iter.hasNext()) {
            javax.xml.registry.infomodel.Classification cls = (javax.xml.registry.infomodel.Classification)iter.next();
            this.internalAddClassification(cls);
        }
        this.setModified(true);
    }

    public void removeClassification(javax.xml.registry.infomodel.Classification c) throws JAXRException {
        if (this.classifications != null) {
            this.getClassifications().remove(c);
            this.setModified(true);
        }
    }

    public void removeClassifications(Collection classifications) throws JAXRException {
        if (classifications != null) {
            this.getClassifications().removeAll(classifications);
            this.setModified(true);
        }
    }

    public void removeAllClassifications() throws JAXRException {
        if (this.classifications != null) {
            this.removeClassifications(this.classifications);
            this.setModified(true);
        }
    }

    public void setClassifications(Collection classifications) throws JAXRException {
        this.removeAllClassifications();
        this.addClassifications(classifications);
        this.setModified(true);
    }

    public Collection getClassifications() throws JAXRException {
        if (this.classifications == null) {
            this.classifications = new ArrayList();
        }
        return this.classifications;
    }

    public Collection getClassificationConceptsByPath(String pathPrefix) throws JAXRException {
        ArrayList<Concept> matchingClassificationConcepts = new ArrayList<Concept>();
        Collection _classifications = this.getClassifications();
        Iterator iter = _classifications.iterator();
        while (iter.hasNext()) {
            javax.xml.registry.infomodel.Classification cl = (javax.xml.registry.infomodel.Classification)iter.next();
            Concept concept = cl.getConcept();
            String conceptPath = concept.getPath();
            if (!conceptPath.startsWith(pathPrefix)) continue;
            matchingClassificationConcepts.add(concept);
        }
        return matchingClassificationConcepts;
    }

    public Collection getAuditTrail() throws JAXRException {
        if (this.auditTrail == null) {
            if (!this.isNew()) {
                String queryStr = "SELECT id FROM AuditableEvent WHERE registryObject = '" + this.getKey().getId() + "'";
                Query query = this.dqm.createQuery(0, queryStr);
                BulkResponse response = this.dqm.executeQuery(query);
                this.checkBulkResponseExceptions(response);
                this.auditTrail = response.getCollection();
            }
            if (this.auditTrail == null) {
                this.auditTrail = new ArrayList();
            }
        }
        return this.auditTrail;
    }

    public User getOwner() throws JAXRException {
        if (!this.isNew()) {
            Collection events = this.getAuditTrail();
            Iterator it = events.iterator();
            while (it.hasNext()) {
                AuditableEventImpl ev = (AuditableEventImpl)it.next();
                if (ev.getEventType() != 0) continue;
                return ev.getUser();
            }
        }
        return null;
    }

    public void addAssociation(Association ass) throws JAXRException {
        this.getAssociations();
        if (!this.associations.contains(ass)) {
            this.associations.add(ass);
        }
        ((AssociationImpl)ass).setSourceObjectInternal(this);
    }

    public void addAssociations(Collection asses) throws JAXRException {
        Iterator it = asses.iterator();
        while (it.hasNext()) {
            Association ass = (Association)it.next();
            this.addAssociation(ass);
        }
    }

    public void removeAssociation(Association ass) throws JAXRException {
        this.getAssociations();
        if (this.associations.contains(ass)) {
            this.associations.remove(ass);
            if (!((AssociationImpl)ass).isNew()) {
                ArrayList<Key> keys = new ArrayList<Key>();
                keys.add(ass.getKey());
                BulkResponse response = this.lcm.deleteObjects(keys);
                RegistryException ex = this.getBulkResponseException(response);
                if (ex != null) {
                    throw ex;
                }
            }
        }
    }

    public void removeAssociations(Collection asses) throws JAXRException {
        Collection savedAsses = this.getAssociations();
        if (this.associations.removeAll(asses)) {
            ArrayList<Key> keys = new ArrayList<Key>();
            Iterator it = asses.iterator();
            while (it.hasNext()) {
                AssociationImpl ass = (AssociationImpl)it.next();
                if (ass.isNew()) continue;
                keys.add(ass.getKey());
            }
            BulkResponse response = this.lcm.deleteObjects(keys);
            RegistryException ex = this.getBulkResponseException(response);
            if (ex != null) {
                this.associations = savedAsses;
                throw ex;
            }
        }
    }

    public void setAssociations(Collection asses) throws JAXRException {
        this.removeAssociations(new ArrayList(this.getAssociations()));
        this.addAssociations(asses);
    }

    public Collection getAssociations() throws JAXRException {
        if (this.associations == null) {
            this.associations = new HashSet();
            if (!this.isNew()) {
                String id = this.getKey().getId();
                String queryStr = "SELECT id FROM Association WHERE sourceObject = '" + id + "'";
                Query query = this.dqm.createQuery(0, queryStr);
                BulkResponse response = this.dqm.executeQuery(query);
                this.checkBulkResponseExceptions(response);
                this.addAssociations(response.getCollection());
            }
        }
        return this.associations;
    }

    public Collection getAssociatedObjects() throws JAXRException {
        if (this.isNew()) {
            return new ArrayList();
        }
        String id = this.getKey().getId();
        String queryStr = "SELECT id FROM Association WHERE sourceObject = '" + id + "' OR targetObject = '" + id + "'";
        Query query = this.dqm.createQuery(0, queryStr);
        BulkResponse response = this.dqm.executeQuery(query);
        this.checkBulkResponseExceptions(response);
        return response.getCollection();
    }

    private void internalAddExternalIdentifier(javax.xml.registry.infomodel.ExternalIdentifier ei) throws JAXRException {
        this.getExternalIdentifiers().add(ei);
    }

    public void addExternalIdentifier(javax.xml.registry.infomodel.ExternalIdentifier ei) throws JAXRException {
        this.internalAddExternalIdentifier(ei);
        ((ExternalIdentifierImpl)ei).setRegistryObject(this);
        this.setModified(true);
    }

    public void addExternalIdentifiers(Collection extLink) throws JAXRException {
        this.getExternalIdentifiers().addAll(extLink);
        this.setModified(true);
    }

    public void removeExternalIdentifier(javax.xml.registry.infomodel.ExternalIdentifier extLink) throws JAXRException {
        if (this.externalIds != null) {
            this.externalIds.remove(extLink);
            this.setModified(true);
        }
    }

    public void removeExternalIdentifiers(Collection extLink) throws JAXRException {
        if (this.externalIds != null) {
            this.externalIds.removeAll(extLink);
            this.setModified(true);
        }
    }

    public void setExternalIdentifiers(Collection extLink) throws JAXRException {
        this.externalIds = extLink;
        this.setModified(true);
    }

    public Collection getExternalIdentifiers() throws JAXRException {
        if (this.externalIds == null) {
            this.externalIds = new ArrayList();
        }
        return this.externalIds;
    }

    public void addExternalLink(ExternalLink extLink) throws JAXRException {
        this.getExternalLinks();
        if (!this.externalLinks.contains(extLink)) {
            boolean associationExists = false;
            BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)this.lcm.getRegistryService().getBusinessQueryManager();
            Concept assocType = bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/ExternallyLinks");
            Collection linkAssociations = extLink.getAssociations();
            if (linkAssociations != null) {
                Iterator assIter = linkAssociations.iterator();
                while (assIter.hasNext()) {
                    Association ass = (Association)assIter.next();
                    if (!ass.getSourceObject().equals(extLink) || !ass.getTargetObject().equals(this) || !ass.getAssociationType().equals(assocType)) continue;
                    associationExists = true;
                    break;
                }
            }
            if (!associationExists) {
                Association ass = this.lcm.createAssociation(this, assocType);
                extLink.addAssociation(ass);
            }
            this.externalLinks.add(extLink);
        }
    }

    public void addExternalLinks(Collection extLinks) throws JAXRException {
        Iterator iter = extLinks.iterator();
        while (iter.hasNext()) {
            ExternalLink extLink = (ExternalLink)iter.next();
            this.addExternalLink(extLink);
        }
    }

    public void removeExternalLink(ExternalLink extLink) throws JAXRException {
        this.getExternalLinks();
        if (this.externalLinks.contains(extLink)) {
            this.externalLinks.remove(extLink);
            ArrayList linkAssociations = new ArrayList(extLink.getAssociations());
            if (linkAssociations != null) {
                Iterator iter = linkAssociations.iterator();
                while (iter.hasNext()) {
                    Association ass = (Association)iter.next();
                    if (ass.getTargetObject() != this || !ass.getAssociationType().getValue().equalsIgnoreCase("ExternallyLinks")) continue;
                    extLink.removeAssociation(ass);
                }
            }
        }
    }

    public void removeExternalLinks(Collection extLinks) throws JAXRException {
        this.getExternalLinks();
        Iterator iter = new ArrayList(extLinks).iterator();
        while (iter.hasNext()) {
            ExternalLink extLink = (ExternalLink)iter.next();
            this.removeExternalLink(extLink);
        }
    }

    public void setExternalLinks(Collection newExternalLinks) throws JAXRException {
        Collection currentExternalLinks = this.getExternalLinks();
        Iterator newExtLinksIter = newExternalLinks.iterator();
        while (newExtLinksIter.hasNext()) {
            ExternalLink externalLink = (ExternalLink)newExtLinksIter.next();
            if (currentExternalLinks.contains(externalLink)) continue;
            this.addExternalLink(externalLink);
        }
        Iterator currentExtLinksIter = new ArrayList(currentExternalLinks).iterator();
        while (currentExtLinksIter.hasNext()) {
            ExternalLink externalLink = (ExternalLink)currentExtLinksIter.next();
            if (newExternalLinks.contains(externalLink)) continue;
            this.removeExternalLink(externalLink);
        }
    }

    public Collection getExternalLinks() throws JAXRException {
        if (this.externalLinks == null) {
            this.externalLinks = new HashSet();
            if (!this.isNew()) {
                String id = this.getId();
                String queryStr = "SELECT id FROM ExternalLink el, Association ass WHERE ass.targetObject = '" + id + "' AND ass.associationType = '" + "urn:uuid:92d03292-84a0-4b86-8139-dd244173ddbb" + "' AND ass.sourceObject = el.id ";
                Query query = this.dqm.createQuery(0, queryStr);
                BulkResponse response = this.dqm.executeQuery(query);
                this.checkBulkResponseExceptions(response);
                this.addExternalLinks(response.getCollection());
            }
        }
        return this.externalLinks;
    }

    public Organization getSubmittingOrganization() throws JAXRException {
        return this.org;
    }

    public Collection getRegistryPackages() throws JAXRException {
        if (this.packages == null) {
            if (!this.isNew()) {
                String queryStr = "SELECT id FROM RegistryPackage WHERE id IN (RegistryObject_registryPackages('" + this.getKey().getId() + "'))";
                Query query = this.dqm.createQuery(0, queryStr);
                BulkResponse response = this.dqm.executeQuery(query);
                this.checkBulkResponseExceptions(response);
                this.packages = response.getCollection();
            }
            if (this.packages == null) {
                this.packages = new ArrayList();
            }
        }
        return this.packages;
    }

    protected void setBindingObject(RegistryObjectType ebObject) throws JAXRException {
        super.setBindingObject(ebObject);
        ebObject.setId(this.key.getId());
        ebObject.setObjectType(this.objectTypeStr);
        Name ebName = new Name();
        ((InternationalStringImpl)this.getName()).setBindingObject(ebName);
        ebObject.setName(ebName);
        Description ebDesc = new Description();
        ((InternationalStringImpl)this.getDescription()).setBindingObject(ebDesc);
        ebObject.setDescription(ebDesc);
        Iterator iter = this.getClassifications().iterator();
        while (iter.hasNext()) {
            ClassificationImpl cls = (ClassificationImpl)iter.next();
            Classification ebCls = cls.toBindingObject();
            ebObject.addClassification(ebCls);
        }
        iter = this.getExternalIdentifiers().iterator();
        while (iter.hasNext()) {
            ExternalIdentifierImpl extId = (ExternalIdentifierImpl)iter.next();
            ExternalIdentifier ebExtId = extId.toBindingObject();
            ebObject.addExternalIdentifier(ebExtId);
        }
    }

    public void getComposedObjects(HashSet composedObjects) throws JAXRException {
        Log log = this.getLog();
        super.getComposedObjects(composedObjects);
        Collection classifications = this.getClassifications();
        composedObjects.addAll(classifications);
        Iterator iter = classifications.iterator();
        while (iter.hasNext()) {
            ClassificationImpl cls = (ClassificationImpl)iter.next();
            cls.getComposedObjects(composedObjects);
        }
        Collection extIds = this.getExternalIdentifiers();
        composedObjects.addAll(extIds);
        iter = extIds.iterator();
        while (iter.hasNext()) {
            ExternalIdentifierImpl extId = (ExternalIdentifierImpl)iter.next();
            extId.getComposedObjects(composedObjects);
        }
    }

    public LifeCycleManager getLifeCycleManager() throws JAXRException {
        return this.lcm;
    }

    RegistryException getBulkResponseException(BulkResponse response) throws JAXRException {
        Collection exceptions = response.getExceptions();
        if (exceptions != null) {
            return (RegistryException)exceptions.iterator().next();
        }
        return null;
    }

    void checkBulkResponseExceptions(BulkResponse response) throws JAXRException {
        RegistryException ex = this.getBulkResponseException(response);
        if (ex != null) {
            throw ex;
        }
    }

    public HashSet getAssociationsAndAssociatedObjects() throws JAXRException {
        HashSet<RegistryObject> assObjects = new HashSet<RegistryObject>();
        Collection asses = this.getAssociations();
        Iterator j = asses.iterator();
        while (j.hasNext()) {
            AssociationImpl ass = (AssociationImpl)j.next();
            RegistryObject target = ass.getTargetObject();
            assObjects.add(target);
        }
        assObjects.addAll(asses);
        return assObjects;
    }

    public HashSet getRegistryObjectRefs() {
        HashSet refs = new HashSet();
        return refs;
    }

    public String toString() {
        String str = super.toString();
        try {
            str = this.getId() + "," + str;
        }
        catch (JAXRException e) {
            try {
                this.getLog().warn((Object)"Error getting id", (Throwable)e);
            }
            catch (JAXRException jAXRException) {
                // empty catch block
            }
        }
        return str;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        int result = -1;
        if (o instanceof RegistryObject) {
            try {
                String myId = this.getId();
                String otherId = ((RegistryObject)o).getKey().getId();
                result = myId.compareTo(otherId);
            }
            catch (JAXRException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected Log getLog() throws JAXRException {
        Log log = ((RegistryServiceImpl)this.lcm.getRegistryService()).getConnection().getConnectionFactory().getLog();
        return log;
    }
}

