/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import com.sun.xml.registry.ebxml.infomodel.ServiceBindingImpl;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.ServiceBinding;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.SpecificationLink;
import org.oasis.ebxml.registry.bindings.rim.SpecificationLinkType;
import org.oasis.ebxml.registry.bindings.rim.UsageDescription;

public class SpecificationLinkImpl
extends RegistryObjectImpl
implements javax.xml.registry.infomodel.SpecificationLink {
    private RegistryObjectRef specificationObjectRef = null;
    private InternationalString usageDescription = null;
    private ArrayList usageParams = new ArrayList();
    private RegistryObjectRef bindingRef = null;

    public SpecificationLinkImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
    }

    public SpecificationLinkImpl(LifeCycleManagerImpl lcm, SpecificationLinkType ebSpecLink) throws JAXRException {
        super(lcm, ebSpecLink);
        if (ebSpecLink.getSpecificationObject() != null) {
            this.specificationObjectRef = new RegistryObjectRef(lcm, ebSpecLink.getSpecificationObject());
        }
        if (ebSpecLink.getUsageDescription() != null) {
            this.usageDescription = new InternationalStringImpl(lcm, ebSpecLink.getUsageDescription());
        }
        String[] usageParamsArr = ebSpecLink.getUsageParameter();
        for (int i = 0; i < usageParamsArr.length; ++i) {
            this.usageParams.add(usageParamsArr[i]);
        }
    }

    public String toXML() throws JAXRException {
        SpecificationLink ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        return sw.toString();
    }

    public RegistryObject getSpecificationObject() throws JAXRException {
        RegistryObject specificationObject = null;
        if (this.specificationObjectRef != null) {
            specificationObject = this.specificationObjectRef.getRegistryObject("RegistryObject");
        }
        return specificationObject;
    }

    public void setSpecificationObject(RegistryObject specificationObject) throws JAXRException {
        this.specificationObjectRef = new RegistryObjectRef(this.lcm, specificationObject);
        this.setModified(true);
    }

    public InternationalString getUsageDescription() throws JAXRException {
        if (this.usageDescription == null) {
            this.usageDescription = this.lcm.createInternationalString();
        }
        return this.usageDescription;
    }

    public void setUsageDescription(InternationalString desc) throws JAXRException {
        this.usageDescription = desc;
        this.setModified(true);
    }

    public Collection getUsageParameters() throws JAXRException {
        return this.usageParams;
    }

    public void setUsageParameters(Collection par1) throws JAXRException {
        this.usageParams.clear();
        this.usageParams.addAll(par1);
        this.setModified(true);
    }

    public RegistryObjectRef getServiceBindingRef() throws JAXRException {
        return this.bindingRef;
    }

    public ServiceBinding getServiceBinding() throws JAXRException {
        ServiceBinding binding = null;
        if (this.bindingRef != null) {
            binding = (ServiceBinding)this.bindingRef.getRegistryObject("ServiceBinding");
        } else if (!this.isNew()) {
            throw new JAXRException("Unfinished code. Contact dev team.");
        }
        return binding;
    }

    void setServiceBindingInternal(ServiceBinding binding) throws JAXRException {
        this.bindingRef = new RegistryObjectRef(this.lcm, binding);
        this.setModified(true);
    }

    void setServiceBinding(ServiceBinding _binding) throws JAXRException {
        if (_binding == null) {
            this.bindingRef = null;
            this.setModified(true);
            return;
        }
        RegistryObjectRef serviceBindingRef = this.getServiceBindingRef();
        if (serviceBindingRef != null) {
            if (!_binding.getKey().getId().equals(serviceBindingRef.getId())) {
                if (!(_binding instanceof ServiceBindingImpl)) {
                    throw new InvalidRequestException("Expected ServiceBindingImpl, got " + _binding);
                }
                this.setServiceBindingInternal(_binding);
            }
        } else {
            this.setServiceBindingInternal(_binding);
        }
    }

    public SpecificationLink toBindingObject() throws JAXRException {
        SpecificationLink ebSpecLink = new SpecificationLink();
        this.setBindingObject(ebSpecLink);
        return ebSpecLink;
    }

    protected void setBindingObject(SpecificationLinkType ebSpecLink) throws JAXRException {
        super.setBindingObject(ebSpecLink);
        if (this.specificationObjectRef != null) {
            ObjectRef ebSpecObjectRef = new ObjectRef();
            ebSpecObjectRef.setId(this.specificationObjectRef.getId());
            ebSpecLink.setSpecificationObject(ebSpecObjectRef);
        }
        UsageDescription ebUsageDesc = new UsageDescription();
        ((InternationalStringImpl)this.getUsageDescription()).setBindingObject(ebUsageDesc);
        ebSpecLink.setUsageDescription(ebUsageDesc);
        Iterator iter = this.getUsageParameters().iterator();
        while (iter.hasNext()) {
            String usageParam = (String)iter.next();
            ebSpecLink.addUsageParameter(usageParam);
        }
    }

    public HashSet getRegistryObjectRefs() {
        HashSet<RegistryObjectRef> refs = new HashSet<RegistryObjectRef>();
        if (this.specificationObjectRef != null) {
            refs.add(this.specificationObjectRef);
        }
        return refs;
    }
}

