/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.EmailAddressImpl;
import com.sun.xml.registry.ebxml.infomodel.OrganizationImpl;
import com.sun.xml.registry.ebxml.infomodel.PersonNameImpl;
import com.sun.xml.registry.ebxml.infomodel.PostalAddressImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import com.sun.xml.registry.ebxml.infomodel.TelephoneNumberImpl;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.User;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.Address;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.TelephoneNumber;
import org.oasis.ebxml.registry.bindings.rim.UserType;

public class UserImpl
extends RegistryObjectImpl
implements User {
    private PersonName personName = null;
    private ArrayList addresses = new ArrayList();
    private ArrayList emails = new ArrayList();
    private ArrayList phones = new ArrayList();
    private URL url = null;
    private String type = null;
    private RegistryObjectRef orgRef = null;

    public UserImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
        this.personName = lcm.createPersonName("", "", "");
    }

    public UserImpl(LifeCycleManagerImpl lcm, UserType ebUser) throws JAXRException {
        super(lcm, ebUser);
        this.personName = new PersonNameImpl(lcm, ebUser.getPersonName());
        PostalAddressImpl address = new PostalAddressImpl(lcm, ebUser.getAddress());
        this.addresses.add(address);
        TelephoneNumber[] tels = ebUser.getTelephoneNumber();
        for (int i = 0; i < tels.length; ++i) {
            this.phones.add(new TelephoneNumberImpl(lcm, tels[i]));
        }
        org.oasis.ebxml.registry.bindings.rim.EmailAddress[] ebEmails = ebUser.getEmailAddress();
        for (int i = 0; i < ebEmails.length; ++i) {
            this.emails.add(new EmailAddressImpl(lcm, ebEmails[i]));
        }
        Object orgObj = ebUser.getOrganization();
        if (orgObj != null) {
            this.orgRef = new RegistryObjectRef(lcm, orgObj);
        }
        try {
            this.url = new URL(ebUser.getUrl());
        }
        catch (MalformedURLException x) {
            // empty catch block
        }
    }

    public String toXML() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.User ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        return sw.toString();
    }

    public PersonName getPersonName() throws JAXRException {
        return this.personName;
    }

    public void setPersonName(PersonName par1) throws JAXRException {
        this.personName = par1;
        this.setModified(true);
    }

    public Collection getPostalAddresses() throws JAXRException {
        return this.addresses;
    }

    public void setPostalAddresses(Collection par1) throws JAXRException {
        this.addresses.clear();
        this.addresses.addAll(par1);
        this.setModified(true);
    }

    public URL getUrl() throws JAXRException {
        return this.url;
    }

    public void setUrl(URL par1) throws JAXRException {
        this.url = par1;
        this.setModified(true);
    }

    public void addTelephoneNumber(javax.xml.registry.infomodel.TelephoneNumber _phone) throws JAXRException {
        this.getTelephoneNumbers().add(_phone);
        this.setModified(true);
    }

    public void addTelephoneNumbers(Collection telephoneNumbers) throws JAXRException {
        Iterator iter = telephoneNumbers.iterator();
        while (iter.hasNext()) {
            javax.xml.registry.infomodel.TelephoneNumber phone = (javax.xml.registry.infomodel.TelephoneNumber)iter.next();
            this.addTelephoneNumber(phone);
        }
        this.setModified(true);
    }

    public void removeTelephoneNumber(javax.xml.registry.infomodel.TelephoneNumber _phone) throws JAXRException {
        if (this.phones != null) {
            this.getTelephoneNumbers().remove(_phone);
            this.setModified(true);
        }
    }

    public void removeTelephoneNumbers(Collection _phones) throws JAXRException {
        if (this.phones != null) {
            this.getTelephoneNumbers().removeAll(_phones);
            this.setModified(true);
        }
    }

    public void removeAllTelephoneNumbers() throws JAXRException {
        if (this.phones != null) {
            this.removeTelephoneNumbers(this.phones);
            this.setModified(true);
        }
    }

    public void setTelephoneNumbers(Collection _phones) throws JAXRException {
        this.removeAllTelephoneNumbers();
        this.addTelephoneNumbers(_phones);
        this.setModified(true);
    }

    public Collection getTelephoneNumbers() throws JAXRException {
        if (this.phones == null) {
            this.phones = new ArrayList();
        }
        return this.phones;
    }

    public Collection getTelephoneNumbers(String phoneType) throws JAXRException {
        return this.getTelephoneNumbers();
    }

    public Collection getEmailAddresses() throws JAXRException {
        return (Collection)this.emails.clone();
    }

    public void setEmailAddresses(Collection par1) throws JAXRException {
        this.emails.clear();
        this.emails.addAll(par1);
        this.setModified(true);
    }

    public String getType() throws JAXRException {
        Slot slot = this.getSlot("UserType");
        return slot == null || slot.getValues().isEmpty() ? null : (String)slot.getValues().iterator().next();
    }

    public void setType(String par1) throws JAXRException {
        this.setModified(true);
        Slot slot = this.getSlot("UserType");
        if (slot == null) {
            if (par1 != null) {
                slot = this.lcm.createSlot("UserType", par1, "UserType");
                this.addSlot(slot);
            }
        } else {
            slot.getValues().clear();
            if (par1 != null) {
                slot.setValues(Collections.singletonList(par1));
            }
        }
    }

    public Organization getOrganization() throws JAXRException {
        if (this.orgRef != null) {
            return (Organization)this.orgRef.getRegistryObject("Organization");
        }
        return null;
    }

    public void setOrganization(Organization org) throws JAXRException {
        this.orgRef = org == null ? null : new RegistryObjectRef(this.lcm, org);
        this.setModified(true);
    }

    public org.oasis.ebxml.registry.bindings.rim.User toBindingObject() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.User ebUser = new org.oasis.ebxml.registry.bindings.rim.User();
        this.setBindingObject(ebUser);
        return ebUser;
    }

    protected void setBindingObject(UserType ebUser) throws JAXRException {
        OrganizationImpl org;
        Iterator iter;
        super.setBindingObject(ebUser);
        org.oasis.ebxml.registry.bindings.rim.PersonName ebPersonName = ((PersonNameImpl)this.personName).toBindingObject();
        ebUser.setPersonName(ebPersonName);
        boolean compatibilityMode = Boolean.valueOf(ProviderProperties.getInstance().getProperty("jaxr-ebxml.tck.compatibilityMode", "false"));
        if (compatibilityMode) {
            if (this.addresses.size() == 0) {
                PostalAddress address = this.lcm.createPostalAddress("streetNumber", "street", "city", "stateOrProvince", "country", "postalCode", "type");
                ArrayList<PostalAddress> _addresses = new ArrayList<PostalAddress>();
                _addresses.add(address);
                this.setPostalAddresses(_addresses);
            }
            if (this.phones.size() == 0) {
                javax.xml.registry.infomodel.TelephoneNumber phone = this.lcm.createTelephoneNumber();
                ArrayList<javax.xml.registry.infomodel.TelephoneNumber> _phones = new ArrayList<javax.xml.registry.infomodel.TelephoneNumber>();
                _phones.add(phone);
                this.setTelephoneNumbers(_phones);
            }
            if (this.emails.size() == 0) {
                EmailAddress email = this.lcm.createEmailAddress("dummy@nowhere.com");
                ArrayList<EmailAddress> _emails = new ArrayList<EmailAddress>();
                _emails.add(email);
                this.setTelephoneNumbers(_emails);
            }
        }
        if ((iter = this.getPostalAddresses().iterator()).hasNext()) {
            PostalAddressImpl addr = (PostalAddressImpl)iter.next();
            Address ebAddress = new Address();
            addr.setBindingObject(ebAddress);
            ebUser.setAddress(ebAddress);
        }
        iter = this.getEmailAddresses().iterator();
        while (iter.hasNext()) {
            EmailAddressImpl email = (EmailAddressImpl)iter.next();
            org.oasis.ebxml.registry.bindings.rim.EmailAddress ebEmail = email.toBindingObject();
            ebUser.addEmailAddress(ebEmail);
        }
        iter = this.getTelephoneNumbers(null).iterator();
        while (iter.hasNext()) {
            TelephoneNumberImpl phone = (TelephoneNumberImpl)iter.next();
            TelephoneNumber ebPhone = phone.toBindingObject();
            ebUser.addTelephoneNumber(ebPhone);
        }
        if (this.url != null) {
            ebUser.setUrl(this.url.toString());
        }
        if ((org = (OrganizationImpl)this.getOrganization()) != null) {
            ebUser.setOrganization(org.toBindingObject());
        }
    }

    public HashSet getRegistryObjectRefs() {
        HashSet<RegistryObjectRef> refs = new HashSet<RegistryObjectRef>();
        if (this.orgRef != null) {
            refs.add(this.orgRef);
        }
        return refs;
    }

    public InternationalString getName() throws JAXRException {
        InternationalString name = null;
        if (this.name == null || this.name.getValue() == null || this.name.getValue().length() == 0) {
            String nameStr = "";
            if (this.personName.getLastName() != null) {
                nameStr = nameStr + this.personName.getLastName();
            }
            if (this.personName.getFirstName() != null) {
                nameStr = nameStr + ", " + this.personName.getFirstName();
            }
            if (this.personName.getMiddleName() != null) {
                nameStr = nameStr + " " + this.personName.getMiddleName();
            }
            name = this.lcm.createInternationalString(nameStr);
        } else {
            name = this.name;
        }
        return name;
    }
}

