/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.JAXRException;

public class ProviderProperties
implements Serializable {
    private static final String PROPERTY_FILE_NAME = "jaxr-ebxml.properties";
    private static final String DEFAULT_SYSTEM_PROPERTY_FILE = "com/sun/xml/registry/ebxml/util/jaxr-ebxml-defaults.properties";
    private static ProviderProperties instance = null;
    private Properties props = null;
    private String userHome = System.getProperty("user.home");
    private String jaxrHome = null;

    private ProviderProperties() {
        String propertyFileName = this.userHome + "/" + PROPERTY_FILE_NAME;
        Properties tempProps = new Properties(this.defaultProperties());
        this.jaxrHome = tempProps.getProperty("jaxr-ebxml.home");
        if (this.jaxrHome == null) {
            tempProps.setProperty("jaxr-ebxml.home", this.userHome + "/jaxr-ebxml");
        }
        try {
            propertyFileName = System.getProperty(PROPERTY_FILE_NAME, propertyFileName);
            FileInputStream is = new FileInputStream(propertyFileName);
            tempProps.load(is);
            ((InputStream)is).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.props = new Properties(tempProps);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties sysProps = ProviderProperties.this.systemProperties();
                Enumeration<Object> keys = sysProps.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ProviderProperties.this.props.put(key, sysProps.getProperty(key));
                }
                return null;
            }
        });
        this.substituteVariables();
    }

    public static ProviderProperties getInstance() {
        if (instance == null) {
            instance = new ProviderProperties();
        }
        return instance;
    }

    public void mergeProperties(Properties p) {
        Set<Object> keys = p.keySet();
        Iterator<Object> i = keys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.props.put(key, p.get(key));
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    public String getProperty(String propertyName, String def) {
        return this.props.getProperty(propertyName, def);
    }

    public Iterator getPropertyNamesStartingWith(String prefix) {
        LinkedList<String> lst = new LinkedList<String>();
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith(prefix)) continue;
            lst.add(propertyName);
        }
        return lst.iterator();
    }

    public void put(Object key, Object value) {
        this.props.put(key, value);
    }

    private void substituteVariables() {
        this.jaxrHome = this.getProperty("jaxr-ebxml.home");
        if (this.jaxrHome == null || this.jaxrHome.length() == 0) {
            String userHome = this.getProperty("user.home");
            File jaxrHomeFile = new File(userHome, "jaxr-ebxml");
            try {
                this.jaxrHome = jaxrHomeFile.getCanonicalPath();
            }
            catch (IOException e) {
                System.err.println("Could not determine path for jaxr-ebxml.home: " + e.toString());
            }
            if (!jaxrHomeFile.exists()) {
                try {
                    boolean createdJaxrHome = jaxrHomeFile.mkdir();
                    if (!createdJaxrHome) {
                        System.err.println("Could not create default home directory " + this.jaxrHome);
                    }
                }
                catch (SecurityException e) {
                    System.err.println("Could not create default home directory " + this.jaxrHome + ": " + e.toString());
                }
            }
            if (!jaxrHomeFile.isDirectory()) {
                System.err.println("jaxr-ebxml.home file \"" + this.jaxrHome + "\" is not a directory");
            }
            this.props.setProperty("jaxr-ebxml.home", this.jaxrHome);
            this.jaxrHome = this.getProperty("jaxr-ebxml.home");
        }
        Enumeration<?> keys = this.props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.getProperty(key);
            System.err.println("key = " + key + " value = " + value);
            if (!key.startsWith("jaxr-ebxml.")) continue;
            int index = -1;
            boolean modified = false;
            while ((index = value.indexOf("$jaxr-ebxml.home")) != -1) {
                value = value.substring(0, index) + this.jaxrHome + value.substring(index + 18);
                modified = true;
            }
            if (!modified) continue;
            this.props.put(key, value);
        }
    }

    private Properties defaultProperties() {
        Properties defaultProps = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_SYSTEM_PROPERTY_FILE);
            if (is == null && (is = this.getClass().getClassLoader().getResourceAsStream("/com/sun/xml/registry/ebxml/util/jaxr-ebxml-defaults.properties")) == null) {
                throw new JAXRException("Property file com/sun/xml/registry/ebxml/util/jaxr-ebxml-defaults.properties not found in classpath");
            }
            defaultProps.load(is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Ignoring com/sun/xml/registry/ebxml/util/jaxr-ebxml-defaults.properties due to exception " + e.toString());
        }
        return defaultProps;
    }

    private Properties systemProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
    }
}

