/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.ser.BaseFactory;

public abstract class BaseDeserializerFactory
extends BaseFactory
implements DeserializerFactory {
    static transient Vector mechanisms = null;
    protected Class deserClass = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected transient Constructor deserClassConstructor = null;
    protected transient Method getDeserializer = null;

    public BaseDeserializerFactory(Class deserClass) {
        this.deserClass = deserClass;
        mechanisms = new Vector();
        mechanisms.add("Axis SAX Mechanism");
    }

    public BaseDeserializerFactory(Class deserClass, QName xmlType, Class javaType) {
        this(deserClass);
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public javax.xml.rpc.encoding.Deserializer getDeserializerAs(String mechanismType) throws JAXRPCException {
        Deserializer deser = null;
        deser = this.getSpecialized(mechanismType);
        if (deser == null) {
            deser = this.getGeneralPurpose(mechanismType);
        }
        try {
            if (deser == null) {
                deser = (Deserializer)this.deserClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
        return deser;
    }

    protected Deserializer getGeneralPurpose(String mechanismType) {
        Constructor deserClassConstructor;
        if (this.javaType != null && this.xmlType != null && (deserClassConstructor = this.getDeserClassConstructor()) != null) {
            try {
                return (Deserializer)deserClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        try {
            return clazz.getConstructor(Class.class, QName.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected Deserializer getSpecialized(String mechanismType) {
        Method getDeserializer;
        if (this.javaType != null && this.xmlType != null && (getDeserializer = this.getGetDeserializer()) != null) {
            try {
                return (Deserializer)getDeserializer.invoke(null, mechanismType, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public Iterator getSupportedMechanismTypes() {
        return mechanisms.iterator();
    }

    public static DeserializerFactory createFactory(Class factory, Class javaType, QName xmlType) {
        DeserializerFactory df = null;
        try {
            Method method = factory.getMethod("create", Class.class, QName.class);
            df = (DeserializerFactory)method.invoke(null, javaType, xmlType);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (df == null) {
            try {
                Constructor constructor = factory.getConstructor(Class.class, QName.class);
                df = (DeserializerFactory)constructor.newInstance(javaType, xmlType);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (df == null) {
            try {
                df = (DeserializerFactory)factory.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return df;
    }

    protected Constructor getDeserClassConstructor() {
        if (this.deserClassConstructor == null) {
            this.deserClassConstructor = this.getConstructor(this.deserClass);
        }
        return this.deserClassConstructor;
    }

    protected Method getGetDeserializer() {
        if (this.getDeserializer == null) {
            this.getDeserializer = this.getMethod(this.javaType, "getDeserializer");
        }
        return this.getDeserializer;
    }
}

