/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.enum.Style;
import org.apache.axis.message.SOAPElementAxisImpl;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    private static Logger log = Logger.getLogger((String)BeanSerializer.class.getName());
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor;
    protected TypeDesc typeDesc;

    public BeanSerializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = typeDesc != null ? typeDesc.getPropertyDescriptors() : BeanUtils.getPd(javaType, null);
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean suppressElement;
        log.debug((Object)("serialize [name=" + name + ",value=" + value + "]"));
        MessageContext messageContext = context.getMessageContext();
        OperationDesc operation = messageContext.getOperation();
        if (operation != null && operation.getStyle() == Style.DOCUMENT) {
            String uri = name.getNamespaceURI();
            String prefix = name.getPrefix();
            if (prefix.length() == 0 && uri.length() > 0) {
                prefix = context.getPrefixForURI(uri);
                if (prefix.equals("")) {
                    prefix = "ns1";
                }
                name = new QName(uri, name.getLocalPart(), prefix);
                context.registerPrefixForURI(prefix, uri);
                context.setNoDefaultNamespace(true);
            }
        }
        Attributes beanAttrs = this.getObjectAttributes(value, attributes, context);
        String encodingStyle = messageContext.getEncodingStyle();
        boolean isEncoded = Constants.isSOAP_ENC(encodingStyle);
        boolean bl = suppressElement = !context.getMessageContext().isEncoded() && name.getNamespaceURI().equals("") && name.getLocalPart().equals("any");
        if (!suppressElement) {
            context.startElement(name, beanAttrs);
        }
        try {
            int i = 0;
            while (true) {
                block22: {
                    int j;
                    Object propValue;
                    QName xmlType;
                    QName qname;
                    BeanPropertyDescriptor bpDesc;
                    block27: {
                        Object anyVal;
                        BeanPropertyDescriptor anyDesc;
                        block23: {
                            block26: {
                                boolean isOmittable;
                                QName itemXmlType;
                                String propName;
                                block24: {
                                    FieldDesc field;
                                    block25: {
                                        if (i >= this.propertyDescriptor.length) break block23;
                                        bpDesc = this.propertyDescriptor[i];
                                        propName = bpDesc.getName();
                                        if (propName.equals("class")) break block22;
                                        qname = null;
                                        xmlType = null;
                                        itemXmlType = null;
                                        isOmittable = false;
                                        if (this.typeDesc == null || (field = this.typeDesc.getFieldByName(propName)) == null) break block24;
                                        if (!field.isElement()) break block22;
                                        if (!((ElementDesc)field).isAsContent()) break block25;
                                        propValue = bpDesc.get(value);
                                        String strval = context.getValueAsString(propValue, xmlType);
                                        context.writeSafeString(strval);
                                        break block22;
                                    }
                                    itemXmlType = ((ElementDesc)field).getItemXmlType();
                                    qname = isEncoded ? new QName(field.getXmlName().getLocalPart()) : field.getXmlName();
                                    isOmittable = field.isMinOccursZero();
                                    xmlType = field.getXmlType();
                                }
                                if (qname == null) {
                                    qname = new QName(propName);
                                }
                                if (xmlType == null) {
                                    xmlType = context.getQNameForClass(bpDesc.getType());
                                }
                                if (!bpDesc.isReadable()) break block22;
                                if (bpDesc.isIndexed()) break block26;
                                Object propValue2 = bpDesc.get(value);
                                if (propValue2 != null || !isOmittable || isEncoded) {
                                    if (!isEncoded && propValue2 != null && JavaUtils.isArrayClass(propValue2.getClass()) && !Constants.XSD_BASE64.equals(xmlType) && !Constants.XSD_HEXBIN.equals(xmlType)) {
                                        QName itemType;
                                        if (itemXmlType == null) {
                                            Class<?> componentType = propValue2.getClass().getComponentType();
                                            itemType = context.getQNameForClass(componentType);
                                        } else {
                                            itemType = itemXmlType;
                                        }
                                        log.debug((Object)("Item type is " + itemType));
                                        for (int j2 = 0; j2 < Array.getLength(propValue2); ++j2) {
                                            Object item = Array.get(propValue2, j2);
                                            context.serialize(qname, null, item, itemType, true, new Boolean(false));
                                        }
                                        break block22;
                                    } else {
                                        context.serialize(qname, null, propValue2, xmlType, true, new Boolean(isEncoded));
                                    }
                                }
                                break block22;
                            }
                            j = 0;
                            break block27;
                        }
                        BeanPropertyDescriptor beanPropertyDescriptor = anyDesc = this.typeDesc == null ? null : this.typeDesc.getAnyDesc();
                        if (anyDesc != null && (anyVal = anyDesc.get(value)) != null && anyVal instanceof SOAPElementAxisImpl[]) {
                            SOAPElementAxisImpl[] anyContent = (SOAPElementAxisImpl[])anyVal;
                            for (int i2 = 0; i2 < anyContent.length; ++i2) {
                                SOAPElementAxisImpl element = anyContent[i2];
                                element.output(context);
                            }
                        }
                        if (!suppressElement) {
                            context.endElement();
                        }
                        return;
                    }
                    while (j >= 0) {
                        propValue = null;
                        try {
                            propValue = bpDesc.get(value, j);
                            ++j;
                        }
                        catch (Exception e) {
                            j = -1;
                        }
                        if (j < 0) continue;
                        context.serialize(qname, null, propValue, xmlType, true, null);
                    }
                }
                ++i;
            }
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            log.error((Object)Messages.getMessage("exception00"), target);
            throw new IOException(target.toString());
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        Element complexType = types.createElement("complexType");
        Element e = null;
        Class superClass = javaType.getSuperclass();
        BeanPropertyDescriptor[] superPd = null;
        List stopClasses = types.getStopClasses();
        if (!(superClass == null || superClass == Object.class || superClass == Exception.class || superClass == Throwable.class || superClass == RemoteException.class || superClass == AxisFault.class || stopClasses != null && stopClasses.contains(superClass.getName()))) {
            String base = types.writeType(superClass);
            Element complexContent = types.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element extension = types.createElement("extension");
            complexContent.appendChild(extension);
            extension.setAttribute("base", base);
            e = extension;
            TypeDesc superTypeDesc = TypeDesc.getTypeDescForClass(superClass);
            superPd = superTypeDesc != null ? superTypeDesc.getPropertyDescriptors() : BeanUtils.getPd(superClass, null);
        } else {
            e = complexType;
        }
        Element all = types.createElement("sequence");
        e.appendChild(all);
        if (Modifier.isAbstract(javaType.getModifiers())) {
            complexType.setAttribute("abstract", "true");
        }
        for (int i = 0; i < this.propertyDescriptor.length; ++i) {
            String propName = this.propertyDescriptor[i].getName();
            boolean writeProperty = true;
            if (propName.equals("class")) {
                writeProperty = false;
            }
            if (superPd != null && writeProperty) {
                for (int j = 0; j < superPd.length && writeProperty; ++j) {
                    if (!propName.equals(superPd[j].getName())) continue;
                    writeProperty = false;
                }
            }
            if (!writeProperty) continue;
            Class fieldType = this.propertyDescriptor[i].getType();
            if (this.typeDesc != null) {
                FieldDesc field = this.typeDesc.getFieldByName(propName);
                if (field != null) {
                    boolean isAnonymous;
                    QName qname = field.getXmlName();
                    QName fieldXmlType = field.getXmlType();
                    boolean bl = isAnonymous = fieldXmlType != null && fieldXmlType.getLocalPart().startsWith(">");
                    if (qname != null) {
                        propName = qname.getLocalPart();
                    }
                    if (!field.isElement()) {
                        this.writeAttribute(types, propName, fieldType, fieldXmlType, complexType);
                        continue;
                    }
                    this.writeField(types, propName, fieldType, this.propertyDescriptor[i].isIndexed(), field.isMinOccursZero(), all, isAnonymous);
                    continue;
                }
                this.writeField(types, propName, fieldType, this.propertyDescriptor[i].isIndexed(), false, all, false);
                continue;
            }
            this.writeField(types, propName, fieldType, this.propertyDescriptor[i].isIndexed(), false, all, false);
        }
        return complexType;
    }

    protected void writeField(Types types, String fieldName, Class fieldType, boolean isUnbounded, boolean isOmittable, Element where, boolean isAnonymous) throws Exception {
        Element elem;
        if (isAnonymous) {
            elem = types.createElementWithAnonymousType(fieldName, fieldType, isOmittable, where.getOwnerDocument());
        } else {
            String elementType = types.writeType(fieldType);
            if (elementType == null) {
                QName anyQN = Constants.XSD_ANYTYPE;
                String prefix = types.getNamespaces().getCreatePrefix(anyQN.getNamespaceURI());
                elementType = prefix + ":" + anyQN.getLocalPart();
            }
            elem = types.createElement(fieldName, elementType, types.isNullable(fieldType), isOmittable, where.getOwnerDocument());
        }
        if (isUnbounded) {
            elem.setAttribute("maxOccurs", "unbounded");
        }
        where.appendChild(elem);
    }

    protected void writeAttribute(Types types, String fieldName, Class fieldType, QName fieldXmlType, Element where) throws Exception {
        if (!types.isAcceptableAsAttribute(fieldType)) {
            throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", fieldName, fieldType.getName()));
        }
        Element elem = types.createAttributeElement(fieldName, fieldType, fieldXmlType, false, where.getOwnerDocument());
        where.appendChild(elem);
    }

    protected Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object propValue;
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (propName.equals("class") || (field = this.typeDesc.getFieldByName(propName)) == null || field.isElement()) continue;
                QName qname = field.getXmlName();
                if (qname == null) {
                    qname = new QName("", propName);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (propValue = this.propertyDescriptor[i].get(value)) == null) continue;
                this.setAttributeProperty(propValue, qname, attrs, context);
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    private void setAttributeProperty(Object propValue, QName qname, AttributesImpl attrs, SerializationContext context) throws Exception {
        String propString = context.getValueAsString(propValue, null);
        String namespace = qname.getNamespaceURI();
        String localName = qname.getLocalPart();
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        QName parentElementQName = (QName)context.getElementStack().peek();
        QName headerQName = soapConstants.getHeaderQName();
        if (headerQName.equals(parentElementQName) && (localName.equals("mustUnderstand") || localName.equals("role"))) {
            namespace = soapConstants.getEnvelopeURI();
        }
        attrs.addAttribute(namespace, localName, context.attributeQName2String(qname), "CDATA", propString);
    }
}

