/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.NameImpl;
import org.apache.axis.message.SOAPBodyAxisImpl;
import org.apache.axis.message.SOAPBodyElementAxisImpl;
import org.apache.axis.message.SOAPElementAxisImpl;
import org.apache.axis.message.SOAPEnvelopeImpl;
import org.apache.axis.message.SOAPHeaderAxisImpl;
import org.apache.axis.message.SOAPHeaderElementAxisImpl;
import org.apache.axis.message.TextImpl;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPEnvelopeAxisImpl
extends SOAPEnvelopeImpl {
    private static Logger log = Logger.getLogger((String)SOAPEnvelopeAxisImpl.class.getName());
    private SOAPHeaderAxisImpl header;
    private SOAPBodyAxisImpl body;
    public Vector trailers = new Vector();
    private SOAPConstants soapConstants;
    private SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    public String messageType;
    private boolean modified;
    private boolean processingRPCInvocation;

    public SOAPEnvelopeAxisImpl() {
        this(true, SOAPConstants.SOAP11_CONSTANTS);
    }

    public SOAPEnvelopeAxisImpl(SOAPConstants soapConstants) {
        this(true, soapConstants);
    }

    public SOAPEnvelopeAxisImpl(SOAPConstants soapConstants, SchemaVersion schemaVersion) {
        this(true, soapConstants, schemaVersion);
    }

    public SOAPEnvelopeAxisImpl(boolean registerPrefixes, SOAPConstants soapConstants) {
        this(registerPrefixes, soapConstants, SchemaVersion.SCHEMA_2001);
    }

    public SOAPEnvelopeAxisImpl(boolean registerPrefixes, SOAPConstants soapConstants, SchemaVersion schemaVersion) {
        super("Envelope", "soapenv", soapConstants != null ? soapConstants.getEnvelopeURI() : Constants.DEFAULT_SOAP_VERSION.getEnvelopeURI());
        if (soapConstants == null) {
            soapConstants = Constants.DEFAULT_SOAP_VERSION;
        }
        this.soapConstants = soapConstants;
        this.schemaVersion = schemaVersion;
        this.setHeader(new SOAPHeaderAxisImpl(this, soapConstants));
        this.setBody(new SOAPBodyAxisImpl(this, soapConstants));
        if (registerPrefixes) {
            if (this.namespaces == null) {
                this.namespaces = new ArrayList();
            }
            this.namespaces.add(new Mapping(soapConstants.getEnvelopeURI(), "soapenv"));
            this.namespaces.add(new Mapping(schemaVersion.getXsdURI(), "xsd"));
            this.namespaces.add(new Mapping(schemaVersion.getXsiURI(), "xsi"));
        }
        this.setDirty(true);
    }

    public static SOAPEnvelopeAxisImpl newSOAPEnvelope(InputStream input) throws SAXException {
        SOAPEnvelopeAxisImpl env = new SOAPEnvelopeAxisImpl();
        InputSource is = new InputSource(input);
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        MessageContext msgContext = new MessageContext(tmpEngine);
        DeserializationContextImpl dser = new DeserializationContextImpl(is, msgContext, "request", env);
        dser.parse();
        return env;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public Vector getBodyElements() throws AxisFault {
        if (this.body != null) {
            return new Vector(this.body.getBodyElements());
        }
        return new Vector();
    }

    public Vector getTrailers() {
        return this.trailers;
    }

    public SOAPBodyElementAxisImpl getFirstBody() throws AxisFault {
        return this.body != null ? this.body.getFirstBody() : null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        log.debug((Object)("setModifiedAfterSerialization: " + modified));
    }

    public boolean isProcessingRPCInvocation() {
        return this.processingRPCInvocation;
    }

    public void setProcessingRPCInvocation(boolean flag) {
        log.debug((Object)("setProcessingRPCInvocation: " + flag));
        this.processingRPCInvocation = flag;
    }

    public Vector getHeaders() throws AxisFault {
        if (this.header != null) {
            return new Vector(this.header.getChildren());
        }
        return new Vector();
    }

    public void addHeader(SOAPHeaderElementAxisImpl hdr) {
        if (this.header == null) {
            this.header = new SOAPHeaderAxisImpl(this, this.soapConstants);
        }
        hdr.setEnvelope(this);
        this.header.addHeader(hdr);
        this.setDirty(true);
    }

    public void addBodyElement(SOAPBodyElementAxisImpl element) {
        element.setEnvelope(this);
        this.body.addBodyElement(element);
        this.setDirty(true);
    }

    public void removeHeaders() {
        this.header = null;
    }

    public void setHeader(SOAPHeaderAxisImpl header) {
        try {
            if (this.header != null) {
                this.removeChild((Node)((Object)this.header));
            }
            header.setParentElement(this);
            this.header = header;
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    public void removeHeader(SOAPHeaderElementAxisImpl hdr) {
        if (this.header != null) {
            this.header.removeHeader(hdr);
            this.setDirty(true);
        }
    }

    public Node removeChild(Node oldChild) throws DOMException {
        super.removeChild(oldChild);
        if (oldChild instanceof SOAPHeaderAxisImpl) {
            this.removeHeaders();
        } else if (oldChild instanceof SOAPBodyAxisImpl) {
            this.removeBody();
        }
        return oldChild;
    }

    public void removeBody() {
        this.body = null;
    }

    public void setBody(SOAPBodyAxisImpl newBody) {
        if (this.body != null) {
            this.removeChild((Node)((Object)this.body));
        }
        try {
            newBody.setParentElement(this);
            this.body = newBody;
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    public void removeBodyElement(SOAPBodyElementAxisImpl element) {
        if (this.body != null) {
            this.body.removeBodyElement(element);
            this.setDirty(true);
        }
    }

    public void removeTrailer(SOAPElementAxisImpl element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("removeTrailer00"));
        }
        this.trailers.removeElement(element);
        this.setDirty(true);
    }

    public void clearBody() {
        if (this.body != null) {
            this.body.clearBody();
            this.setDirty(true);
        }
    }

    public void addTrailer(SOAPElementAxisImpl element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("removeTrailer00"));
        }
        element.setEnvelope(this);
        this.trailers.addElement(element);
        this.setDirty(true);
    }

    public SOAPHeaderElementAxisImpl getHeaderByName(String namespace, String localPart) throws AxisFault {
        return this.getHeaderByName(namespace, localPart, false);
    }

    public SOAPHeaderElementAxisImpl getHeaderByName(String namespace, String localPart, boolean accessAllHeaders) throws AxisFault {
        if (this.header != null) {
            return this.header.getHeaderByName(namespace, localPart, accessAllHeaders);
        }
        return null;
    }

    public SOAPBodyElementAxisImpl getBodyByName(String namespace, String localPart) throws AxisFault {
        return this.body != null ? this.body.getBodyByName(namespace, localPart) : null;
    }

    public Enumeration getHeadersByName(String namespace, String localPart) throws AxisFault {
        return this.getHeadersByName(namespace, localPart, false);
    }

    public Enumeration getHeadersByName(String namespace, String localPart, boolean accessAllHeaders) throws AxisFault {
        if (this.header != null) {
            return this.header.getHeadersByName(namespace, localPart, accessAllHeaders);
        }
        return new Vector().elements();
    }

    public void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        context.setPretty(true);
        if (this.namespaces != null) {
            Iterator i = this.namespaces.iterator();
            while (i.hasNext()) {
                Mapping mapping = (Mapping)i.next();
                context.registerPrefixForURI(mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
        context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Envelope"), this.attributes);
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node childNode = (Node)it.next();
            if (childNode instanceof SOAPHeaderAxisImpl || childNode instanceof SOAPBodyAxisImpl) continue;
            if (childNode instanceof SOAPElementAxisImpl) {
                ((SOAPElementAxisImpl)((Object)childNode)).output(context);
                continue;
            }
            if (!(childNode instanceof TextImpl)) continue;
            context.writeString(childNode.getNodeValue());
        }
        if (this.header != null) {
            this.header.outputImpl(context);
        }
        if (this.body != null) {
            this.body.outputImpl(context);
        }
        Enumeration enumeration = this.trailers.elements();
        while (enumeration.hasMoreElements()) {
            SOAPElementAxisImpl element = (SOAPElementAxisImpl)enumeration.nextElement();
            element.output(context);
        }
        context.endElement();
        context.setPretty(oldPretty);
        this.setModified(false);
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSoapConstants(SOAPConstants soapConstants) {
        this.soapConstants = soapConstants;
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public SOAPBody addBody() throws SOAPException {
        if (this.body == null) {
            this.setBody(new SOAPBodyAxisImpl(this, this.soapConstants));
            return this.body;
        }
        throw new SOAPException(Messages.getMessage("bodyPresent"));
    }

    public SOAPHeader addHeader() throws SOAPException {
        if (this.header == null) {
            this.header = new SOAPHeaderAxisImpl(this, this.soapConstants);
            return this.header;
        }
        throw new SOAPException(Messages.getMessage("headerPresent"));
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public SOAPBody getBody() {
        return this.body;
    }

    public SOAPHeader getHeader() {
        return this.header;
    }

    public void setSAAJEncodingCompliance(boolean comply) {
        this.body.setSAAJEncodingCompliance(comply);
    }
}

