/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPElementAxisImpl;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.message.SOAPHeaderElementAxisImpl;
import org.apache.axis.message.SOAPHeaderImpl;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class SOAPHeaderAxisImpl
extends SOAPHeaderImpl {
    private static Logger log = Logger.getLogger((String)SOAPHeaderAxisImpl.class.getName());
    private SOAPConstants soapConstants;

    SOAPHeaderAxisImpl(SOAPEnvelopeAxisImpl env, SOAPConstants soapConsts) {
        super("Header", "soapenv", soapConsts != null ? soapConsts.getEnvelopeURI() : Constants.DEFAULT_SOAP_VERSION.getEnvelopeURI());
        this.soapConstants = soapConsts != null ? soapConsts : Constants.DEFAULT_SOAP_VERSION;
        try {
            this.setParentElement(env);
            this.setEnvelope(env);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    public SOAPHeaderAxisImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context, SOAPConstants soapConsts) throws AxisFault {
        super(namespace, localPart, prefix, attributes, context);
        this.soapConstants = soapConsts != null ? soapConsts : Constants.DEFAULT_SOAP_VERSION;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            SOAPEnvelopeAxisImpl env = (SOAPEnvelopeAxisImpl)parent;
            super.setParentElement(env);
            this.setEnvelope(env);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAPHeaderElementAxisImpl headerElement = new SOAPHeaderElementAxisImpl(name);
        SOAPEnvelopeAxisImpl envelope = this.getEnvelope();
        headerElement.setEnvelope(envelope);
        this.addHeader(headerElement);
        envelope.setDirty(true);
        return headerElement;
    }

    public Iterator examineHeaderElements(String actor) {
        ArrayList results = new ArrayList();
        this.getHeaderElements(results, actor);
        return results.iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        ArrayList results = new ArrayList();
        this.getHeaderElements(results, actor);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            this.removeChild((Node)((Object)((SOAPHeaderElementAxisImpl)iterator.next())));
        }
        return results.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        ArrayList results = new ArrayList();
        this.getHeaderElements(results, actor);
        Iterator it = results.iterator();
        while (it.hasNext()) {
            SOAPHeaderElementAxisImpl she = (SOAPHeaderElementAxisImpl)it.next();
            if (she.getMustUnderstand()) continue;
            it.remove();
        }
        return results.iterator();
    }

    public Iterator examineAllHeaderElements() {
        return this.getChildren().iterator();
    }

    public Iterator extractAllHeaderElements() {
        Vector result = new Vector(this.getChildren());
        this.removeChildren();
        return result.iterator();
    }

    private void getHeaderElements(ArrayList results, String actor) {
        String nextActor = SOAPConstants.SOAP11_CONSTANTS.getNextRoleURI();
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            SOAPHeaderElementAxisImpl she = (SOAPHeaderElementAxisImpl)it.next();
            String headerActor = she.getActor();
            if ((!nextActor.equals(headerActor) || she.getMustUnderstand()) && (actor == null || !actor.equals(headerActor))) continue;
            results.add(she);
        }
    }

    void addHeader(SOAPHeaderElementAxisImpl header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("addHeader00"));
        }
        try {
            header.setParentElement(this);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    void removeHeader(SOAPHeaderElementAxisImpl header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("removeHeader00"));
        }
        this.removeChild((Node)((Object)header));
    }

    SOAPHeaderElementAxisImpl getHeaderByName(String namespace, String localPart, boolean accessAllHeaders) {
        MessageContext mc;
        SOAPHeaderElementAxisImpl header = (SOAPHeaderElementAxisImpl)this.findElement(namespace, localPart);
        if (!accessAllHeaders && (mc = MessageContext.getCurrentContext()) != null && header != null) {
            String actor = header.getActor();
            String nextActor = this.getEnvelope().getSOAPConstants().getNextRoleURI();
            if (nextActor.equals(actor)) {
                return header;
            }
            SOAPService soapService = mc.getService();
            if (soapService != null) {
                ArrayList actors = mc.getService().getActors();
                if (!(actor == null || actors != null && actors.contains(actor))) {
                    header = null;
                }
            }
        }
        return header;
    }

    private SOAPElementAxisImpl findElement(String namespace, String localPart) {
        if (!this.hasChildNodes()) {
            return null;
        }
        QName qname = new QName(namespace, localPart);
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            SOAPHeaderElementAxisImpl she = (SOAPHeaderElementAxisImpl)it.next();
            if (!she.getQName().equals(qname)) continue;
            return she;
        }
        return null;
    }

    Enumeration getHeadersByName(String namespace, String localPart, boolean accessAllHeaders) {
        ArrayList actors = null;
        boolean firstTime = false;
        Vector<SOAPHeaderElementAxisImpl> v = new Vector<SOAPHeaderElementAxisImpl>();
        String nextActor = this.getEnvelope().getSOAPConstants().getNextRoleURI();
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            SOAPHeaderElementAxisImpl she = (SOAPHeaderElementAxisImpl)it.next();
            if (!she.getNamespaceURI().equals(namespace) || !she.getName().equals(localPart)) continue;
            if (!accessAllHeaders) {
                String actor;
                if (firstTime) {
                    MessageContext mc = MessageContext.getCurrentContext();
                    if (mc != null) {
                        actors = mc.getAxisEngine().getActorURIs();
                    }
                    firstTime = false;
                }
                if ((actor = she.getActor()) != null && !nextActor.equals(actor) && (actors == null || !actors.contains(actor))) continue;
            }
            v.addElement(she);
        }
        return v.elements();
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        context.setPretty(true);
        if (this.hasChildNodes()) {
            context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Header"), null);
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                SOAPHeaderElementAxisImpl she = (SOAPHeaderElementAxisImpl)it.next();
                she.output(context);
            }
            context.endElement();
        }
        context.setPretty(oldPretty);
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        if (!(element instanceof SOAPHeaderElement)) {
            throw new SOAPException(Messages.getMessage("badSOAPHeader00"));
        }
        return super.addChildElement(element);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPHeaderElementAxisImpl child = new SOAPHeaderElementAxisImpl(name.getURI(), name.getLocalName());
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPHeaderElementAxisImpl child = new SOAPHeaderElementAxisImpl(this.getNamespaceURI(), localName);
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        SOAPHeaderElementAxisImpl child = new SOAPHeaderElementAxisImpl(this.getNamespaceURI(prefix), localName);
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPHeaderElementAxisImpl child = new SOAPHeaderElementAxisImpl(uri, localName);
        child.setPrefix(prefix);
        child.addNamespaceDeclaration(prefix, uri);
        this.addChild(child);
        child.setEnvelope(this.getEnvelope());
        return child;
    }
}

