/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentSupport;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.message.MimeHeadersImpl;
import org.apache.axis.message.SOAPMessageAxisImpl;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class SOAPMessageImpl
extends SOAPMessage {
    private static Logger log = Logger.getLogger((String)SOAPMessageAxisImpl.class.getName());
    protected SOAPPart mSOAPPart;
    protected Attachments mAttachments;
    protected MimeHeadersImpl headers;
    private Hashtable mProps = new Hashtable();
    private boolean saveRequired = true;

    protected SOAPMessageImpl() {
    }

    public void writeTo(OutputStream os) throws SOAPException, IOException {
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.mSOAPPart.getEnvelope().getBody();
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.mSOAPPart.getEnvelope().getHeader();
    }

    public void setProperty(String property, Object value) throws SOAPException {
        this.mProps.put(property, value);
    }

    public Object getProperty(String property) throws SOAPException {
        return this.mProps.get(property);
    }

    public String getContentDescription() {
        String[] values = this.headers.getHeader("Content-Description");
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.headers.setHeader("Content-Description", description);
    }

    public void saveChanges() throws SOAPException {
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public void removeAllAttachments() {
        this.mAttachments.removeAllAttachments();
    }

    public int countAttachments() {
        return this.mAttachments == null ? 0 : this.mAttachments.getAttachmentCount();
    }

    public Iterator getAttachments() {
        try {
            if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
                return this.mAttachments.getAttachments().iterator();
            }
        }
        catch (AxisFault af) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)af);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return this.mAttachments.getAttachments(headers);
    }

    public void addAttachmentPart(AttachmentPart attachmentpart) {
        try {
            this.mAttachments.addAttachmentPart((Part)attachmentpart);
        }
        catch (AxisFault af) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)af);
        }
    }

    public AttachmentPart createAttachmentPart() {
        if (!AttachmentSupport.isAttachmentSupportEnabled()) {
            throw new RuntimeException(Messages.getMessage("noAttachments"));
        }
        try {
            return (AttachmentPart)this.mAttachments.createAttachmentPart();
        }
        catch (AxisFault af) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)af);
            return null;
        }
    }
}

