/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;

public class TypeDesc {
    public static final Class[] noClasses = new Class[0];
    public static final Object[] noObjects = new Object[0];
    private static Map classMap = new Hashtable();
    private boolean lookedForAny = false;
    private Class javaClass = null;
    private QName xmlType = null;
    private FieldDesc[] fields;
    private HashMap fieldNameMap = new HashMap();
    private HashMap fieldElementMap = null;
    private boolean _hasAttributes = false;
    private BeanPropertyDescriptor[] propertyDescriptors = null;
    private Map propertyMap = null;
    private BeanPropertyDescriptor anyDesc = null;

    public TypeDesc(Class javaClass) {
        this.javaClass = javaClass;
    }

    public static void registerTypeDescForClass(Class cls, TypeDesc td) {
        classMap.put(cls, td);
    }

    public static TypeDesc getTypeDescForClass(Class cls) {
        TypeDesc result = (TypeDesc)classMap.get(cls);
        if (result != null) {
            return result;
        }
        try {
            Method getTypeDesc = null;
            try {
                getTypeDesc = cls.getMethod("getTypeDesc", noClasses);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (getTypeDesc == null) {
                Class helper = ClassUtils.forName(cls.getName() + "_Helper");
                try {
                    getTypeDesc = helper.getMethod("getTypeDesc", noClasses);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (getTypeDesc != null) {
                return (TypeDesc)getTypeDesc.invoke(null, noObjects);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public BeanPropertyDescriptor getAnyDesc() {
        return this.anyDesc;
    }

    public FieldDesc[] getFields() {
        return this.fields;
    }

    public FieldDesc[] getFields(boolean searchParents) {
        FieldDesc[] parentFields;
        TypeDesc superDesc;
        Class cls;
        if (searchParents && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null && (parentFields = superDesc.getFields(true)) != null) {
            if (this.fields != null) {
                FieldDesc[] ret = new FieldDesc[parentFields.length + this.fields.length];
                System.arraycopy(parentFields, 0, ret, 0, parentFields.length);
                System.arraycopy(this.fields, 0, ret, parentFields.length, this.fields.length);
                this.fields = ret;
            } else {
                FieldDesc[] ret = new FieldDesc[parentFields.length];
                System.arraycopy(parentFields, 0, ret, 0, parentFields.length);
                this.fields = ret;
            }
        }
        return this.fields;
    }

    public void setFields(FieldDesc[] newFields) {
        this.fieldNameMap = new HashMap();
        this.fields = newFields;
        this._hasAttributes = false;
        this.fieldElementMap = null;
        for (int i = 0; i < newFields.length; ++i) {
            FieldDesc field = newFields[i];
            if (field.isElement()) {
                this.fieldNameMap.put(field.getFieldName(), field);
                continue;
            }
            this._hasAttributes = true;
        }
    }

    public void addFieldDesc(FieldDesc field) {
        if (field == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullFieldDesc"));
        }
        int numFields = 0;
        if (this.fields != null) {
            numFields = this.fields.length;
        }
        FieldDesc[] newFields = new FieldDesc[numFields + 1];
        if (this.fields != null) {
            System.arraycopy(this.fields, 0, newFields, 0, numFields);
        }
        newFields[numFields] = field;
        this.fields = newFields;
        this.fieldNameMap.put(field.getFieldName(), field);
        if (!this._hasAttributes && !field.isElement()) {
            this._hasAttributes = true;
        }
    }

    public QName getElementNameForField(String fieldName) {
        FieldDesc desc = (FieldDesc)this.fieldNameMap.get(fieldName);
        if (desc == null) {
            TypeDesc superDesc;
            Class cls = this.javaClass.getSuperclass();
            if (cls != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
                return superDesc.getElementNameForField(fieldName);
            }
        } else if (!desc.isElement()) {
            return null;
        }
        return desc.getXmlName();
    }

    public QName getAttributeNameForField(String fieldName) {
        QName ret;
        FieldDesc desc = (FieldDesc)this.fieldNameMap.get(fieldName);
        if (desc == null) {
            TypeDesc superDesc;
            Class cls = this.javaClass.getSuperclass();
            if (cls != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
                return superDesc.getAttributeNameForField(fieldName);
            }
        } else if (desc.isElement()) {
            return null;
        }
        if ((ret = desc.getXmlName()) == null) {
            ret = new QName("", fieldName);
        }
        return ret;
    }

    public String getFieldNameForElement(QName qname) {
        TypeDesc superDesc;
        Class cls;
        String cached;
        if (this.fieldElementMap != null && (cached = (String)this.fieldElementMap.get(qname)) != null) {
            return cached;
        }
        String result = null;
        String localPart = qname.getLocalPart();
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            QName xmlName;
            FieldDesc field = this.fields[i];
            if (!field.isElement() || !localPart.equals((xmlName = field.getXmlName()).getLocalPart()) || !qname.getNamespaceURI().equals(xmlName.getNamespaceURI())) continue;
            result = field.getFieldName();
            break;
        }
        if (result == null && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            result = superDesc.getFieldNameForElement(qname);
        }
        if (result != null) {
            if (this.fieldElementMap == null) {
                this.fieldElementMap = new HashMap();
            }
            this.fieldElementMap.put(qname, result);
        }
        return result;
    }

    public String getFieldNameForAttribute(QName qname) {
        TypeDesc superDesc;
        Class cls;
        String possibleMatch = null;
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            FieldDesc field = this.fields[i];
            if (field.isElement()) continue;
            if (qname.equals(field.getXmlName())) {
                return field.getFieldName();
            }
            if (!qname.getNamespaceURI().equals("") || !qname.getLocalPart().equals(field.getFieldName())) continue;
            possibleMatch = field.getFieldName();
        }
        if (possibleMatch == null && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            possibleMatch = superDesc.getFieldNameForAttribute(qname);
        }
        return possibleMatch;
    }

    public FieldDesc getFieldByName(String name) {
        TypeDesc superDesc;
        Class cls;
        FieldDesc ret = (FieldDesc)this.fieldNameMap.get(name);
        if (ret == null && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            ret = superDesc.getFieldByName(name);
        }
        return ret;
    }

    public boolean hasAttributes() {
        return this._hasAttributes;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName xmlType) {
        this.xmlType = xmlType;
    }

    public BeanPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = BeanUtils.getPd(this.javaClass, this);
            if (!this.lookedForAny) {
                this.anyDesc = BeanUtils.getAnyContentPD(this.javaClass);
                this.lookedForAny = true;
            }
        }
        return this.propertyDescriptors;
    }

    public void setPropertyDescriptors(BeanPropertyDescriptor[] propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
        this.propertyMap = null;
    }

    public BeanPropertyDescriptor getAnyContentDescriptor() {
        if (!this.lookedForAny) {
            this.anyDesc = BeanUtils.getAnyContentPD(this.javaClass);
            this.lookedForAny = true;
        }
        return this.anyDesc;
    }

    public Map getPropertyDescriptorMap() {
        if (this.propertyMap != null) {
            return this.propertyMap;
        }
        if (this.propertyDescriptors == null) {
            this.getPropertyDescriptors();
        }
        this.propertyMap = new HashMap();
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            BeanPropertyDescriptor descriptor = this.propertyDescriptors[i];
            this.propertyMap.put(descriptor.getName(), descriptor);
        }
        return this.propertyMap;
    }
}

