/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.enum.Scope;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.session.Session;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class JavaProvider
extends BasicProvider {
    private static Logger log = Logger.getLogger((String)JavaProvider.class.getName());
    public static final String OPTION_CLASSNAME = "className";
    public static final String OPTION_ALLOWEDMETHODS = "allowedMethods";
    public static final String OPTION_IS_STATIC = "isStatic";
    public static final String OPTION_CLASSPATH = "classPath";
    public static final String OPTION_WSDL_PORTTYPE = "wsdlPortType";
    public static final String OPTION_WSDL_SERVICEELEMENT = "wsdlServiceElement";
    public static final String OPTION_WSDL_SERVICEPORT = "wsdlServicePort";
    public static final String OPTION_WSDL_TARGETNAMESPACE = "wsdlTargetNamespace";
    public static final String OPTION_WSDL_INPUTSCHEMA = "wsdlInputSchema";
    public static final String OPTION_SCOPE = "scope";

    public Object getServiceObject(MessageContext msgContext, Handler service, String clsName, IntHolder scopeHolder) throws Exception {
        String serviceName = msgContext.getService().getName();
        Scope scope = Scope.getScope((String)service.getOption(OPTION_SCOPE), Scope.DEFAULT);
        scopeHolder.value = scope.getValue();
        if (scope == Scope.REQUEST) {
            return this.getNewServiceObject(msgContext, clsName);
        }
        if (scope == Scope.SESSION) {
            Session session;
            if (serviceName == null) {
                serviceName = msgContext.getService().toString();
            }
            if ((session = msgContext.getSession()) != null) {
                return this.getSessionServiceObject(session, serviceName, msgContext, clsName);
            }
            scopeHolder.value = Scope.DEFAULT.getValue();
            return this.getNewServiceObject(msgContext, clsName);
        }
        if (scope == Scope.APPLICATION) {
            AxisEngine engine = msgContext.getAxisEngine();
            Session appSession = engine.getApplicationSession();
            if (appSession != null) {
                return this.getSessionServiceObject(appSession, serviceName, msgContext, clsName);
            }
            scopeHolder.value = Scope.DEFAULT.getValue();
            return this.getNewServiceObject(msgContext, clsName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSessionServiceObject(Session session, String serviceName, MessageContext msgContext, String clsName) throws Exception {
        Object obj = null;
        boolean makeNewObject = false;
        Object object = session.getLockObject();
        synchronized (object) {
            obj = session.get(serviceName);
            if (obj == null) {
                obj = new LockObject();
                makeNewObject = true;
                session.set(serviceName, obj);
            }
        }
        if (LockObject.class == obj.getClass()) {
            LockObject lock = (LockObject)obj;
            if (makeNewObject) {
                try {
                    obj = this.getNewServiceObject(msgContext, clsName);
                    session.set(serviceName, obj);
                }
                finally {
                    lock.complete();
                }
            } else {
                lock.waitUntilComplete();
                obj = session.get(serviceName);
            }
        }
        return obj;
    }

    private Object getNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        Object serviceObject = this.makeNewServiceObject(msgContext, clsName);
        if (serviceObject != null && serviceObject instanceof ServiceLifecycle) {
            ((ServiceLifecycle)serviceObject).init(msgContext.getProperty("servletEndpointContext"));
        }
        return serviceObject;
    }

    public abstract void processMessage(MessageContext var1, SOAPEnvelopeAxisImpl var2, SOAPEnvelopeAxisImpl var3, Object var4) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        block11: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enter: JavaProvider::invoke (" + this + ")"));
            }
            String serviceName = msgContext.getTargetService();
            SOAPService service = msgContext.getService();
            String clsName = this.getServiceClassName(service);
            if (clsName == null || clsName.equals("")) {
                throw new AxisFault("Server.NoClassForService", Messages.getMessage("noOption00", this.getServiceClassNameOptionName(), serviceName), null, null);
            }
            IntHolder scope = new IntHolder();
            Object serviceObject = null;
            try {
                try {
                    SOAPEnvelopeAxisImpl resEnv;
                    serviceObject = this.getServiceObject(msgContext, service, clsName, scope);
                    Message resMsg = msgContext.getResponseMessage();
                    if (resMsg == null) {
                        resEnv = new SOAPEnvelopeAxisImpl(msgContext.getSOAPConstants(), msgContext.getSchemaVersion());
                        resMsg = new Message(resEnv);
                        msgContext.setResponseMessage(resMsg);
                    } else {
                        resEnv = resMsg.getSOAPEnvelope();
                    }
                    Message reqMsg = msgContext.getRequestMessage();
                    SOAPEnvelopeAxisImpl reqEnv = reqMsg.getSOAPEnvelope();
                    this.processMessage(msgContext, reqEnv, resEnv, serviceObject);
                }
                catch (Exception ex) {
                    this.processException(ex);
                    log.error((Object)"Detect unprocessed exception", (Throwable)ex);
                    throw AxisFault.makeFault(ex);
                }
                Object var12_12 = null;
                if (serviceObject == null) break block11;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (serviceObject != null && scope.value == Scope.REQUEST.getValue() && serviceObject instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)serviceObject).destroy();
                }
                throw throwable;
            }
            if (scope.value == Scope.REQUEST.getValue() && serviceObject instanceof ServiceLifecycle) {
                ((ServiceLifecycle)serviceObject).destroy();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: JavaProvider::invoke (" + this + ")"));
        }
    }

    protected void processException(Exception ex) throws AxisFault {
        SAXException exp;
        Exception real;
        if (ex instanceof AxisFault) {
            throw (AxisFault)ex;
        }
        if (ex instanceof JAXRPCException) {
            JAXRPCException rte = (JAXRPCException)((Object)ex);
            if (rte.getLinkedCause() instanceof AxisFault) {
                throw (AxisFault)rte.getLinkedCause();
            }
            AxisFault fault = AxisFault.makeFault(ex);
            fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION, "true");
            throw fault;
        }
        if (ex instanceof SAXException && (real = (exp = (SAXException)ex).getException()) != null) {
            throw AxisFault.makeFault(real);
        }
        AxisFault fault = AxisFault.makeFault(ex);
        throw fault;
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: JavaProvider::generateWSDL (" + this + ")"));
        }
        SOAPService service = msgContext.getService();
        ServiceDesc serviceDesc = service.getInitializedServiceDesc(msgContext);
        try {
            String wsdlInputSchema;
            String interfaceNamespace;
            String locationUrl = msgContext.getStrProp("axis.wsdlgen.serv.loc.url");
            if (locationUrl == null) {
                locationUrl = serviceDesc.getEndpointURL();
            }
            if (locationUrl == null) {
                locationUrl = msgContext.getStrProp("transport.url");
            }
            if ((interfaceNamespace = msgContext.getStrProp("axis.wsdlgen.intfnamespace")) == null) {
                interfaceNamespace = serviceDesc.getDefaultNamespace();
            }
            if (interfaceNamespace == null) {
                interfaceNamespace = locationUrl;
            }
            Emitter emitter = new Emitter();
            String alias = (String)service.getOption("alias");
            if (alias != null) {
                emitter.setServiceElementName(alias);
            }
            emitter.setStyle(serviceDesc.getStyle());
            emitter.setUse(serviceDesc.getUse());
            emitter.setClsSmart(serviceDesc.getImplClass(), locationUrl);
            String targetNamespace = (String)service.getOption(OPTION_WSDL_TARGETNAMESPACE);
            if (targetNamespace == null || targetNamespace.length() == 0) {
                targetNamespace = interfaceNamespace;
            }
            emitter.setIntfNamespace(targetNamespace);
            emitter.setLocationUrl(locationUrl);
            emitter.setServiceDesc(serviceDesc);
            emitter.setTypeMapping((TypeMapping)msgContext.getTypeMappingRegistry().getTypeMapping(serviceDesc.getUse().getEncoding()));
            emitter.setDefaultTypeMapping((TypeMapping)msgContext.getTypeMappingRegistry().getDefaultTypeMapping());
            String wsdlPortType = (String)service.getOption(OPTION_WSDL_PORTTYPE);
            String wsdlServiceElement = (String)service.getOption(OPTION_WSDL_SERVICEELEMENT);
            String wsdlServicePort = (String)service.getOption(OPTION_WSDL_SERVICEPORT);
            if (wsdlPortType != null && wsdlPortType.length() > 0) {
                emitter.setPortTypeName(wsdlPortType);
            }
            if (wsdlServiceElement != null && wsdlServiceElement.length() > 0) {
                emitter.setServiceElementName(wsdlServiceElement);
            }
            if (wsdlServicePort != null && wsdlServicePort.length() > 0) {
                emitter.setServicePortName(wsdlServicePort);
            }
            if (null != (wsdlInputSchema = (String)service.getOption(OPTION_WSDL_INPUTSCHEMA)) && wsdlInputSchema.length() > 0) {
                emitter.setInputSchema(wsdlInputSchema);
            }
            Document doc = emitter.emit(0);
            msgContext.setProperty("WSDL", doc);
        }
        catch (NoClassDefFoundError e) {
            log.info((Object)Messages.getMessage("toAxisFault00"), (Throwable)e);
            throw new AxisFault(e.toString(), e);
        }
        catch (Exception e) {
            log.info((Object)Messages.getMessage("toAxisFault00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: JavaProvider::generateWSDL (" + this + ")"));
        }
    }

    private String getAllowedMethods(Handler service) {
        String val = (String)service.getOption(OPTION_ALLOWEDMETHODS);
        if (val == null || val.length() == 0) {
            val = (String)service.getOption("methodName");
        }
        return val;
    }

    protected Object makeNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        Object serviceObject = null;
        ClassLoader cl = msgContext.getClassLoader();
        ClassCache cache = msgContext.getAxisEngine().getClassCache();
        if (cache != null) {
            log.debug((Object)("makeNewServiceObject from cache: " + clsName));
            JavaClass jc = cache.lookup(clsName, cl);
            serviceObject = jc.getJavaClass().newInstance();
        } else {
            log.debug((Object)("makeNewServiceObject for name: " + clsName));
            Class serviceClass = ClassUtils.forName(clsName, true, cl);
            serviceObject = serviceClass.newInstance();
        }
        return serviceObject;
    }

    protected String getServiceClassName(Handler service) {
        return (String)service.getOption(this.getServiceClassNameOptionName());
    }

    protected String getServiceClassNameOptionName() {
        return OPTION_CLASSNAME;
    }

    protected Class getServiceClass(String clsName, SOAPService service, MessageContext msgContext) throws AxisFault {
        ClassLoader cl = null;
        Class serviceClass = null;
        AxisEngine engine = service.getEngine();
        cl = msgContext != null ? msgContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
        if (engine != null && engine.getClassCache() != null) {
            try {
                JavaClass jc = engine.getClassCache().lookup(clsName, cl);
                serviceClass = jc.getJavaClass();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                throw new AxisFault(Messages.getMessage("noClassForService00", clsName), e);
            }
        }
        if (serviceClass == null) {
            try {
                serviceClass = ClassUtils.forName(clsName, true, cl);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                throw new AxisFault(Messages.getMessage("noClassForService00", clsName), e);
            }
        }
        return serviceClass;
    }

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        String allowedMethods;
        String clsName = this.getServiceClassName(service);
        if (clsName == null) {
            throw new AxisFault(Messages.getMessage("noServiceClass"));
        }
        Class cls = this.getServiceClass(clsName, service, msgContext);
        ServiceDesc serviceDescription = service.getServiceDescription();
        if (serviceDescription.getAllowedMethods() == null && service != null && (allowedMethods = this.getAllowedMethods(service)) != null && !"*".equals(allowedMethods)) {
            ArrayList<String> methodList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(allowedMethods, " ,");
            while (tokenizer.hasMoreTokens()) {
                methodList.add(tokenizer.nextToken());
            }
            serviceDescription.setAllowedMethods(methodList);
        }
        serviceDescription.loadServiceDescByIntrospection(cls);
    }

    class LockObject {
        private boolean completed = false;

        LockObject() {
        }

        synchronized void waitUntilComplete() throws InterruptedException {
            while (!this.completed) {
                this.wait();
            }
        }

        synchronized void complete() {
            this.completed = true;
            this.notifyAll();
        }
    }
}

