/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class DOM2Utils {
    private static Logger log = Logger.getLogger((String)DOM2Utils.class.getName());
    private static DocumentBuilder builder = DOM2Utils.getDocumentBuilder();

    private DOM2Utils() {
    }

    public static DocumentBuilder getDocumentBuilder() {
        if (builder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error((Object)e);
            }
        }
        return builder;
    }

    public static Element createElement(Element parent, String localPart) {
        Document doc = DOM2Utils.getOwnerDocument(parent);
        log.debug((Object)("createElement {}" + localPart));
        return doc.createElement(localPart);
    }

    public static Element createElement(Element parent, String localPart, String prefix) {
        Document doc = DOM2Utils.getOwnerDocument(parent);
        log.debug((Object)("createElement {}" + prefix + ":" + localPart));
        return doc.createElement(prefix + ":" + localPart);
    }

    public static Element createElement(Element parent, String uri, String prefix, String localPart) {
        Document doc = DOM2Utils.getOwnerDocument(parent);
        if (prefix == null || prefix.length() == 0) {
            log.debug((Object)("createElement {" + uri + "}" + localPart));
            return doc.createElementNS(uri, localPart);
        }
        log.debug((Object)("createElement {" + uri + "}" + prefix + ":" + localPart));
        return doc.createElementNS(uri, prefix + ":" + localPart);
    }

    public static Element createElement(Element parent, Name name) {
        return DOM2Utils.createElement(parent, name.getURI(), name.getPrefix(), name.getLocalName());
    }

    public static Text createTextNode(String value) {
        Document doc = builder.newDocument();
        return doc.createTextNode(value);
    }

    private static Document getOwnerDocument(Node parent) {
        Document doc = null;
        if (parent != null) {
            doc = parent.getOwnerDocument();
        }
        if (doc == null) {
            doc = builder.newDocument();
        }
        return doc;
    }
}

