/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.deployment.AspectDeployerMBean;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;

public class AspectDeployer
extends SubDeployerSupport
implements SubDeployer,
AspectDeployerMBean {
    public static final String AOP_DD_KEY = "AOP_DD";

    public AspectDeployer() {
        this.setSuffixes(new String[]{"aop", "aop.xml"});
        this.setRelativeOrder(100);
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith("aop") || urlStr.endsWith(".aop/") || urlStr.endsWith("aop.xml");
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        boolean debug = this.log.isDebugEnabled();
        try {
            if (di.watch == null) {
                File file;
                di.watch = di.url.getProtocol().equals("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/jboss-aop.xml")) : di.url;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed to parse AOP document: ", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        super.init(di);
    }

    private URL getDocUrl(DeploymentInfo di, URLClassLoader localCL) throws DeploymentException {
        URL docURL = di.localUrl;
        if (!di.isXML) {
            docURL = localCL.findResource("META-INF/jboss-aop.xml");
        }
        if (docURL == null) {
            throw new DeploymentException("Failed to find META-INF/jboss-aop.xml");
        }
        return docURL;
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        try {
            if (!di.isXML) {
                Iterator it = ArchiveBrowser.getBrowser((URL)di.url, (ArchiveBrowser.Filter)new ClassFileFilter());
                AspectAnnotationLoader loader = new AspectAnnotationLoader();
                loader.deployInputStreamIterator(it);
            }
            URL docURL = this.getDocUrl(di, di.localCl);
            AspectXmlLoader.deployXML((URL)docURL);
            Notification msg = new Notification("AOP Deploy", this, this.getNextNotificationSequenceNumber());
            this.sendNotification(msg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DeploymentException((Throwable)ex);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
    }

    public void stop(DeploymentInfo di) {
        this.log.debug((Object)("undeploying document " + di.url));
        try {
            URL docURL = this.getDocUrl(di, di.localCl);
            AspectXmlLoader.undeployXML((URL)docURL);
            Notification msg = new Notification("AOP Undeploy", this, this.getNextNotificationSequenceNumber());
            this.sendNotification(msg);
        }
        catch (Exception ex) {
            this.log.error((Object)"failed to stop", (Throwable)ex);
        }
    }

    public void destroy(DeploymentInfo di) {
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? AspectDeployerMBean.OBJECT_NAME : name;
    }
}

