/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassPoolFactory;
import org.jboss.aop.deployment.JBossClassPool;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossClassPoolFactory
implements ClassPoolFactory {
    protected File tmpClassesDir;

    public JBossClassPoolFactory(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public AOPClassPool create(ClassLoader cl, ClassPool src, AspectManager manager) {
        try {
            File tempdir = this.createTempDir(cl);
            return new JBossClassPool(cl, src, manager, tempdir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AOPClassPool create(ClassPool src, AspectManager manager) {
        return new JBossClassPool(src, manager);
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        if (!(cl instanceof RepositoryClassLoader)) {
            return null;
        }
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        tempdir.delete();
        tempdir.mkdir();
        tempdir.deleteOnExit();
        RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
        URL tmpURL = tempdir.toURL();
        URL tmpCP = new URL(tmpURL, "?dynamic=true");
        ucl.addURL(tmpCP);
        return tempdir;
    }
}

