/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.ioc;

import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aspects.ioc.DependencyInjectorContainer;

public class IocInterceptor
implements Interceptor,
InterceptorFactory {
    public boolean isDeployed() {
        return true;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object rtn = invocation.invokeNext();
        Method[] methods = rtn.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("set") || !methods[i].getReturnType().equals(Void.TYPE) || methods[i].getParameterTypes().length != 1) continue;
            String propname = methods[i].getName().substring(3);
            Class<?> type = methods[i].getParameterTypes()[0];
            Object value = DependencyInjectorContainer.getProperty(propname, type);
            Object[] args = new Object[]{value};
            methods[i].invoke(rtn, args);
        }
        return rtn;
    }

    public Interceptor create(Advisor advisor, Joinpoint jp) {
        return this;
    }
}

