/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.util.PayloadKey;
import org.jboss.remoting.ClientInterceptor;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;

public class AOPToRemotingClientAdapter
implements Interceptor,
Serializable {
    public static final AOPToRemotingClientAdapter singleton = new AOPToRemotingClientAdapter();
    public static final String REMOTING = "REMOTING";
    public static final String REMOTING_CONTEXT = "REMOTING_CONTEXT";
    public static final String INVOKER_LOCATOR = "INVOKER_LOCATOR";
    public static final String SUBSYSTEM = "SUBSYSTEM";
    public static final String CLIENT_INTERCEPTOR = "CLIENT_INTERCEPTOR";

    public String getName() {
        return "AOPToRemotingClientAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        ClientInterceptor ci;
        InvokerLocator locator = (InvokerLocator)invocation.getMetaData((Object)REMOTING, (Object)INVOKER_LOCATOR);
        String subsystem = (String)invocation.getMetaData((Object)REMOTING, (Object)SUBSYSTEM);
        if (subsystem == null) {
            subsystem = "AOP";
        }
        if ((ci = (ClientInterceptor)invocation.getMetaData((Object)REMOTING, (Object)CLIENT_INTERCEPTOR)) == null) {
            throw new RuntimeException("No remoting client interceptor supplied.  Can't invoke remotely--nothing to invoke!");
        }
        Map requestPayload = (Map)invocation.getMetaData((Object)REMOTING, (Object)REMOTING_CONTEXT);
        invocation.getMetaData().removeMetaData((Object)REMOTING, (Object)REMOTING_CONTEXT);
        InvocationRequest ireq = new InvocationRequest("sessionID", subsystem, (Object)invocation, requestPayload, null, locator);
        try {
            InvocationResponse ir = (InvocationResponse)ci.invoke(ireq);
            invocation.setResponseContextInfo(ir.getContextInfo());
            invocation.addResponseAttachment((Object)REMOTING_CONTEXT, (Object)ireq.getReturnPayload());
            Object object = ir.getResponse();
            return object;
        }
        finally {
            invocation.getMetaData().addMetaData((Object)REMOTING, (Object)REMOTING_CONTEXT, (Object)requestPayload, PayloadKey.TRANSIENT);
        }
    }
}

