/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class ScpClient {
    private SshClient ssh;
    private File cwd;
    private boolean verbose;

    protected ScpClient(File file, SshClient sshClient, boolean bl) {
        this.ssh = sshClient;
        this.cwd = file;
        this.verbose = bl;
    }

    public void put(String string, String string2, boolean bl) throws IOException {
        ScpChannel scpChannel;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (!file.exists()) {
            throw new IOException(String.valueOf(String.valueOf(string)).concat(" does not exist"));
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException(String.valueOf(String.valueOf(string)).concat(" is not a regular file or directory"));
        }
        if (file.isDirectory() && !bl) {
            throw new IOException(String.valueOf(String.valueOf(string)).concat(" is a directory, use recursive mode"));
        }
        if (string2 == null || string2.equals("")) {
            string2 = ".";
        }
        if (!this.ssh.openChannel(scpChannel = new ScpChannel(this, String.valueOf(String.valueOf(new StringBuffer("scp ").append(file.isDirectory() ? "-d " : "").append("-t ").append(bl ? "-r " : "").append(this.verbose ? "-v " : "").append(string2)))))) {
            throw new IOException("Failed to open SCP channel");
        }
        scpChannel.waitForResponse();
        scpChannel.writeFileToRemote(file, bl);
        scpChannel.close();
    }

    public void put(String[] stringArray, String string, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (stringArray.length == 1) {
            this.put(stringArray[0], string, bl);
        } else {
            ScpChannel scpChannel = new ScpChannel(this, String.valueOf(String.valueOf(new StringBuffer("scp -d -t ").append(bl ? "-r " : "").append(this.verbose ? "-v " : "").append(string))));
            if (!this.ssh.openChannel(scpChannel)) {
                throw new IOException("Failed to open SCP channel");
            }
            scpChannel.waitForResponse();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.isAbsolute()) {
                    file = new File(this.cwd, stringArray[i]);
                }
                if (!file.isFile() && !file.isDirectory()) {
                    throw new IOException(String.valueOf(String.valueOf(file.getName())).concat(" is not a regular file or directory"));
                }
                scpChannel.writeFileToRemote(file, bl);
            }
            scpChannel.close();
        }
    }

    public void get(String string, String[] stringArray, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\" ");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.trim();
        this.get(string, string2, bl);
    }

    public void get(String string, String string2, boolean bl) throws IOException {
        File file;
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new IOException(String.valueOf(String.valueOf(string)).concat(" is not a regular file or directory"));
        }
        ScpChannel scpChannel = new ScpChannel(this, String.valueOf(String.valueOf(new StringBuffer("scp -f ").append(bl ? "-r " : "").append(this.verbose ? "-v " : "").append(string2))));
        if (!this.ssh.openChannel(scpChannel)) {
            throw new IOException("Failed to open SCP Channel");
        }
        scpChannel.readFromRemote(file);
        scpChannel.close();
    }

    class ScpChannel
    extends SessionChannelClient {
        byte[] buffer = new byte[16384];
        String cmd;

        ScpChannel(ScpClient scpClient, String string) {
            this.cmd = string;
        }

        protected void onChannelOpen() throws IOException {
            if (!this.executeCommand(this.cmd)) {
                throw new IOException("Failed to execute the command ".concat(String.valueOf(String.valueOf(this.cmd))));
            }
        }

        private boolean writeDirToRemote(File file, boolean bl) throws IOException {
            if (!bl) {
                this.writeError(String.valueOf(String.valueOf(new StringBuffer("File ").append(file.getName()).append(" is a directory, use recursive mode"))));
                return false;
            }
            String string = String.valueOf(String.valueOf(new StringBuffer("D0755 0 ").append(file.getName()).append("\n")));
            this.out.write(string.getBytes());
            this.waitForResponse();
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                this.writeFileToRemote(file2, bl);
            }
            this.out.write("E\n".getBytes());
            return true;
        }

        private void writeFileToRemote(File file, boolean bl) throws IOException {
            if (file.isDirectory()) {
                if (!this.writeDirToRemote(file, bl)) {
                    return;
                }
            } else if (file.isFile()) {
                String string = String.valueOf(String.valueOf(new StringBuffer("C0644 ").append(file.length()).append(" ").append(file.getName()).append("\n")));
                this.out.write(string.getBytes());
                this.waitForResponse();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.writeCompleteFile(fileInputStream, file.length());
                this.out.write(0);
            } else {
                throw new IOException(String.valueOf(String.valueOf(file.getName())).concat(" not valid for SCP"));
            }
            this.waitForResponse();
        }

        private void readFromRemote(File file) throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.out.write(0);
            block7: while (true) {
                try {
                    string = this.readString();
                }
                catch (EOFException eOFException) {
                    return;
                }
                char c = string.charAt(0);
                switch (c) {
                    case 'E': {
                        this.out.write(0);
                        return;
                    }
                    case 'T': {
                        throw new IOException("SCP time not supported: ".concat(String.valueOf(String.valueOf(string))));
                    }
                    case 'C': 
                    case 'D': {
                        Object object;
                        String string2 = file.getAbsolutePath();
                        this.parseCommand(string, stringArray);
                        if (file.isDirectory()) {
                            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(File.separator)).concat(String.valueOf(String.valueOf(stringArray[2]))))));
                        }
                        File file2 = new File(string2);
                        if (c == 'D') {
                            if (file2.exists()) {
                                if (!file2.isDirectory()) {
                                    object = String.valueOf(String.valueOf(new StringBuffer("Invalid target ").append(file2.getName()).append(", must be a directory")));
                                    this.writeError((String)object);
                                    throw new IOException((String)object);
                                }
                            } else if (!file2.mkdir()) {
                                object = "Could not create directory: ".concat(String.valueOf(String.valueOf(file2.getName())));
                                this.writeError((String)object);
                                throw new IOException((String)object);
                            }
                            this.readFromRemote(file2);
                            continue block7;
                        }
                        object = new FileOutputStream(file2);
                        this.out.write(0);
                        long l = Long.parseLong(stringArray[1]);
                        this.readCompleteFile((FileOutputStream)object, l);
                        this.waitForResponse();
                        this.out.write(0);
                        continue block7;
                    }
                }
                break;
            }
            this.writeError("Unexpected cmd: ".concat(String.valueOf(String.valueOf(string))));
            throw new IOException("SCP unexpected cmd: ".concat(String.valueOf(String.valueOf(string))));
        }

        private void parseCommand(String string, String[] stringArray) throws IOException {
            int n = string.indexOf(32);
            int n2 = string.indexOf(32, n + 1);
            if (n == -1 || n2 == -1) {
                this.writeError("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            stringArray[0] = string.substring(1, n);
            stringArray[1] = string.substring(n + 1, n2);
            stringArray[2] = string.substring(n2 + 1);
        }

        private String readString() throws IOException {
            int n;
            int n2 = 0;
            while ((n = this.in.read()) != 10 && n >= 0) {
                this.buffer[n2++] = (byte)n;
            }
            if (n == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            if (this.buffer[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.buffer[0] == 2 || this.buffer[0] == 1) {
                String string = new String(this.buffer, 1, n2 - 1);
                if (this.buffer[0] == 2) {
                    throw new IOException(string);
                }
                throw new IOException("SCP returned an unexpected error: ".concat(String.valueOf(String.valueOf(string))));
            }
            return new String(this.buffer, 0, n2);
        }

        private void waitForResponse() throws IOException {
            int n = this.in.read();
            if (n == 0) {
                return;
            }
            if (n == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String string = this.readString();
            if (n == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: ".concat(String.valueOf(String.valueOf(string))));
        }

        private void writeError(String string) throws IOException {
            this.out.write(1);
            this.out.write(string.getBytes());
        }

        private void writeCompleteFile(FileInputStream fileInputStream, long l) throws IOException {
            int n = 0;
            try {
                while ((long)n < l) {
                    int n2 = fileInputStream.read(this.buffer, 0, (int)(l - (long)n < (long)this.buffer.length ? l - (long)n : (long)this.buffer.length));
                    if (n2 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n += n2;
                    this.out.write(this.buffer, 0, n2);
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
        }

        private void readCompleteFile(FileOutputStream fileOutputStream, long l) throws IOException {
            int n = 0;
            try {
                while ((long)n < l) {
                    int n2 = this.in.read(this.buffer, 0, (int)(l - (long)n < (long)this.buffer.length ? l - (long)n : (long)this.buffer.length));
                    if (n2 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n += n2;
                    fileOutputStream.write(this.buffer, 0, n2);
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
        }
    }
}

