/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshRuntimeException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.util.HashMap;

public class SshThread
extends Thread {
    private static HashMap names = new HashMap();
    protected byte[] sessionId;
    protected String sessionIdString = null;
    protected String username;
    private HashMap settings = new HashMap();

    public SshThread(Runnable runnable, String string, boolean bl) {
        super(runnable);
        Integer n = names.containsKey(string) ? new Integer((Integer)names.get(string) + 1) : new Integer(1);
        names.put(string, n);
        this.setName(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(Integer.toHexString(n & 0xFF)))));
        this.setDaemon(bl);
        if (ConfigurationLoader.isContextClassLoader()) {
            this.setContextClassLoader(ConfigurationLoader.getContextClassLoader());
        }
    }

    public void setSessionId(byte[] byArray) {
        if (byArray != null) {
            this.sessionId = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.sessionId, 0, byArray.length);
            this.sessionIdString = String.valueOf((long)new String(byArray).hashCode() & 0xFFFFFFFFL);
        }
    }

    public String getSessionIdString() {
        return this.sessionIdString;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public SshThread cloneThread(Runnable runnable, String string) {
        SshThread sshThread = new SshThread(runnable, string, this.isDaemon());
        sshThread.setSessionId(this.sessionId);
        sshThread.setUsername(this.username);
        sshThread.settings.putAll(this.settings);
        return sshThread;
    }

    public void setProperty(String string, Object object) {
        this.settings.put(string, object);
    }

    public Object getProperty(String string) {
        return this.settings.get(string);
    }

    public boolean containsProperty(String string) {
        return this.settings.containsKey(string);
    }

    public static String getCurrentThreadUser() throws SshRuntimeException {
        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread)Thread.currentThread()).getUsername();
        }
        throw new SshRuntimeException("The current thread is not running within an SshThread context");
    }

    public static String getCurrentSessionId() throws SshRuntimeException {
        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread)Thread.currentThread()).getSessionIdString();
        }
        throw new SshRuntimeException("The current thread is not running within an SshThread context");
    }

    public static SshThread getCurrentThread() throws SshRuntimeException {
        if (Thread.currentThread() instanceof SshThread) {
            return (SshThread)Thread.currentThread();
        }
        throw new SshRuntimeException("The current thread is not an SshThread");
    }
}

