/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class AgentForwardingChannel
extends Channel {
    public static final String AGENT_FORWARDING_CHANNEL = "auth-agent";
    protected Socket socket = null;
    private boolean isForwarding;

    public AgentForwardingChannel(boolean bl) {
        this.isForwarding = bl;
    }

    public String getChannelType() {
        return AGENT_FORWARDING_CHANNEL;
    }

    public void bindSocket(Socket socket) throws IOException {
        this.socket = socket;
        if (this.state.getValue() == 2) {
            this.bindInputStream(socket.getInputStream());
            this.bindOutputStream(socket.getOutputStream());
        }
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        if (bl) {
            this.connection.sendChannelRequestFailure(this);
        }
    }

    protected int getMaximumPacketSize() {
        return 32678;
    }

    protected void onChannelClose() throws IOException {
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected void onChannelOpen() throws InvalidChannelException {
        try {
            if (this.socket != null) {
                if (this.isForwarding) {
                    SshAgentForwardingNotice sshAgentForwardingNotice = new SshAgentForwardingNotice(InetAddress.getLocalHost().getHostName(), InetAddress.getLocalHost().getHostAddress(), this.socket.getPort());
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeBinaryString(sshAgentForwardingNotice.toByteArray());
                    this.connection.sendChannelData(this, byteArrayWriter.toByteArray());
                }
                this.bindInputStream(this.socket.getInputStream());
                this.bindOutputStream(this.socket.getOutputStream());
            }
        }
        catch (IOException iOException) {
            throw new InvalidChannelException(iOException.getMessage());
        }
    }

    protected int getMaximumWindowSpace() {
        return 32768;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }
}

