/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.agent.KeyStoreListener;
import com.sshtools.j2ssh.agent.KeyTimeoutException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStore {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$agent$KeyStore == null ? (class$com$sshtools$j2ssh$agent$KeyStore = KeyStore.class$("com.sshtools.j2ssh.agent.KeyStore")) : class$com$sshtools$j2ssh$agent$KeyStore));
    HashMap publickeys = new HashMap();
    HashMap privatekeys = new HashMap();
    HashMap constraints = new HashMap();
    Vector index = new Vector();
    Vector listeners = new Vector();
    String lockedPassword = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$KeyStore;

    public Map getPublicKeys() {
        return (Map)this.publickeys.clone();
    }

    public int indexOf(SshPublicKey sshPublicKey) {
        return this.index.indexOf(sshPublicKey);
    }

    public SshPublicKey elementAt(int n) {
        return (SshPublicKey)this.index.elementAt(n);
    }

    public String getDescription(SshPublicKey sshPublicKey) {
        return (String)this.publickeys.get(sshPublicKey);
    }

    public KeyConstraints getKeyConstraints(SshPublicKey sshPublicKey) {
        return (KeyConstraints)this.constraints.get(sshPublicKey);
    }

    public int size() {
        return this.index.size();
    }

    public void addKeyStoreListener(KeyStoreListener keyStoreListener) {
        this.listeners.add(keyStoreListener);
    }

    public void removeKeyStoreListener(KeyStoreListener keyStoreListener) {
        this.listeners.remove(keyStoreListener);
    }

    public boolean addKey(SshPrivateKey sshPrivateKey, SshPublicKey sshPublicKey, String string, KeyConstraints keyConstraints) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (!this.publickeys.containsKey(sshPublicKey)) {
                this.publickeys.put(sshPublicKey, string);
                this.privatekeys.put(sshPublicKey, sshPrivateKey);
                this.constraints.put(sshPublicKey, keyConstraints);
                this.index.add(sshPublicKey);
                Iterator iterator = ((AbstractList)this.listeners).iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onAddKey(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void deleteAllKeys() {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            this.publickeys.clear();
            this.privatekeys.clear();
            this.constraints.clear();
            this.index.clear();
            Iterator iterator = ((AbstractList)this.listeners).iterator();
            while (iterator.hasNext()) {
                KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                keyStoreListener.onDeleteAllKeys(this);
            }
        }
    }

    public byte[] performHashAndSign(SshPublicKey sshPublicKey, List list, byte[] byArray) throws InvalidSshKeyException, KeyTimeoutException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.privatekeys.containsKey(sshPublicKey)) {
                SshPrivateKey sshPrivateKey = (SshPrivateKey)this.privatekeys.get(sshPublicKey);
                KeyConstraints keyConstraints = (KeyConstraints)this.constraints.get(sshPublicKey);
                if (keyConstraints.canUse()) {
                    if (!keyConstraints.hasTimedOut()) {
                        keyConstraints.use();
                        byte[] byArray2 = sshPrivateKey.generateSignature(byArray);
                        Iterator iterator = ((AbstractList)this.listeners).iterator();
                        while (iterator.hasNext()) {
                            KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                            keyStoreListener.onKeyOperation(this, "hash-and-sign");
                        }
                        byte[] byArray3 = byArray2;
                        return byArray3;
                    }
                    throw new KeyTimeoutException();
                }
                throw new KeyTimeoutException();
            }
            throw new InvalidSshKeyException("The key does not exist");
        }
    }

    public boolean deleteKey(SshPublicKey sshPublicKey, String string) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            String string2;
            if (this.publickeys.containsKey(sshPublicKey) && string.equals(string2 = (String)this.publickeys.get(sshPublicKey))) {
                this.publickeys.remove(sshPublicKey);
                this.privatekeys.remove(sshPublicKey);
                this.constraints.remove(sshPublicKey);
                this.index.remove(sshPublicKey);
                Iterator iterator = ((AbstractList)this.listeners).iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onDeleteKey(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean lock(String string) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.lockedPassword == null) {
                this.lockedPassword = string;
                Iterator iterator = ((AbstractList)this.listeners).iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onLock(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean unlock(String string) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.lockedPassword != null && string.equals(this.lockedPassword)) {
                this.lockedPassword = null;
                Iterator iterator = ((AbstractList)this.listeners).iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onUnlock(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

