/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;

class SshAgentAddKey
extends SubsystemMessage {
    public static final int SSH_AGENT_ADD_KEY = 202;
    SshPrivateKey prvkey;
    SshPublicKey pubkey;
    String description;
    KeyConstraints constraints;

    public SshAgentAddKey() {
        super(202);
    }

    public SshAgentAddKey(SshPrivateKey sshPrivateKey, SshPublicKey sshPublicKey, String string, KeyConstraints keyConstraints) {
        super(202);
        this.prvkey = sshPrivateKey;
        this.pubkey = sshPublicKey;
        this.description = string;
        this.constraints = keyConstraints;
    }

    public SshPrivateKey getPrivateKey() {
        return this.prvkey;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    public KeyConstraints getKeyConstraints() {
        return this.constraints;
    }

    public String getMessageName() {
        return "SSH_AGENT_ADD_KEY";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException, IOException {
        try {
            byteArrayWriter.writeBinaryString(this.prvkey.getEncoded());
            byteArrayWriter.writeBinaryString(this.pubkey.getEncoded());
            byteArrayWriter.writeString(this.description);
            byteArrayWriter.write(this.constraints.toByteArray());
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException, IOException {
        try {
            this.prvkey = SshKeyPairFactory.decodePrivateKey(byteArrayReader.readBinaryString());
            this.pubkey = SshKeyPairFactory.decodePublicKey(byteArrayReader.readBinaryString());
            this.description = byteArrayReader.readString();
            this.constraints = new KeyConstraints(byteArrayReader);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }
}

