/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.agent.SshAgentAddKey;
import com.sshtools.j2ssh.agent.SshAgentAlive;
import com.sshtools.j2ssh.agent.SshAgentDeleteAllKeys;
import com.sshtools.j2ssh.agent.SshAgentDeleteKey;
import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.agent.SshAgentKeyList;
import com.sshtools.j2ssh.agent.SshAgentListKeys;
import com.sshtools.j2ssh.agent.SshAgentLock;
import com.sshtools.j2ssh.agent.SshAgentOperationComplete;
import com.sshtools.j2ssh.agent.SshAgentPing;
import com.sshtools.j2ssh.agent.SshAgentPrivateKeyOp;
import com.sshtools.j2ssh.agent.SshAgentRandom;
import com.sshtools.j2ssh.agent.SshAgentRandomData;
import com.sshtools.j2ssh.agent.SshAgentRequestVersion;
import com.sshtools.j2ssh.agent.SshAgentSuccess;
import com.sshtools.j2ssh.agent.SshAgentUnlock;
import com.sshtools.j2ssh.agent.SshAgentVersionResponse;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentClient {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$agent$SshAgentClient == null ? (class$com$sshtools$j2ssh$agent$SshAgentClient = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentClient")) : class$com$sshtools$j2ssh$agent$SshAgentClient));
    public static final String HASH_AND_SIGN = "hash-and-sign";
    InputStream in;
    OutputStream out;
    boolean isForwarded = false;
    HashMap messages = new HashMap();
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentAlive;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentKeyList;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentOperationComplete;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentRandomData;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentSuccess;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentVersionResponse;

    SshAgentClient(boolean bl, String string, InputStream inputStream, OutputStream outputStream) throws IOException {
        log.info((Object)"New SshAgentClient instance created");
        this.in = inputStream;
        this.out = outputStream;
        this.isForwarded = bl;
        this.registerMessages();
        if (bl) {
            this.sendForwardingNotice();
        } else {
            this.sendVersionRequest(string);
        }
    }

    public static SshAgentClient connectLocalAgent(String string, String string2, int n) throws IOException, AgentNotAvailableException {
        try {
            Socket socket = SshAgentClient.connectAgentSocket(string2, n);
            SshAgentClient sshAgentClient = new SshAgentClient(false, string, socket.getInputStream(), socket.getOutputStream());
            return sshAgentClient;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new AgentNotAvailableException();
        }
    }

    public static Socket connectAgentSocket(String string, int n) throws IOException, AgentNotAvailableException {
        try {
            if (string == null) {
                throw new AgentNotAvailableException();
            }
            int n2 = string.indexOf(":");
            if (n2 == -1) {
                throw new AgentNotAvailableException();
            }
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(string2, n3), n > 0 ? n : 0);
            Socket socket2 = socket;
            return socket2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new AgentNotAvailableException();
        }
    }

    public static SshAgentClient connectForwardedAgent(String string, Channel channel) throws IOException {
        return new SshAgentClient(true, string, channel.getInputStream(), channel.getOutputStream());
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }

    protected void registerMessages() {
        this.messages.put(new Integer(103), class$com$sshtools$j2ssh$agent$SshAgentVersionResponse == null ? (class$com$sshtools$j2ssh$agent$SshAgentVersionResponse = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentVersionResponse")) : class$com$sshtools$j2ssh$agent$SshAgentVersionResponse);
        this.messages.put(new Integer(101), class$com$sshtools$j2ssh$agent$SshAgentSuccess == null ? (class$com$sshtools$j2ssh$agent$SshAgentSuccess = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentSuccess")) : class$com$sshtools$j2ssh$agent$SshAgentSuccess);
        this.messages.put(new Integer(102), class$com$sshtools$j2ssh$agent$SshAgentFailure == null ? (class$com$sshtools$j2ssh$agent$SshAgentFailure = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentFailure")) : class$com$sshtools$j2ssh$agent$SshAgentFailure);
        this.messages.put(new Integer(104), class$com$sshtools$j2ssh$agent$SshAgentKeyList == null ? (class$com$sshtools$j2ssh$agent$SshAgentKeyList = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentKeyList")) : class$com$sshtools$j2ssh$agent$SshAgentKeyList);
        this.messages.put(new Integer(106), class$com$sshtools$j2ssh$agent$SshAgentRandomData == null ? (class$com$sshtools$j2ssh$agent$SshAgentRandomData = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentRandomData")) : class$com$sshtools$j2ssh$agent$SshAgentRandomData);
        this.messages.put(new Integer(150), class$com$sshtools$j2ssh$agent$SshAgentAlive == null ? (class$com$sshtools$j2ssh$agent$SshAgentAlive = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentAlive")) : class$com$sshtools$j2ssh$agent$SshAgentAlive);
        this.messages.put(new Integer(105), class$com$sshtools$j2ssh$agent$SshAgentOperationComplete == null ? (class$com$sshtools$j2ssh$agent$SshAgentOperationComplete = SshAgentClient.class$("com.sshtools.j2ssh.agent.SshAgentOperationComplete")) : class$com$sshtools$j2ssh$agent$SshAgentOperationComplete);
    }

    protected void sendVersionRequest(String string) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentRequestVersion(string);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (subsystemMessage instanceof SshAgentVersionResponse) {
            SshAgentVersionResponse sshAgentVersionResponse = (SshAgentVersionResponse)subsystemMessage;
            if (sshAgentVersionResponse.getVersion() != 2) {
                throw new IOException("The agent verison is not compatible with verison 2");
            }
        } else {
            throw new IOException("The agent did not respond with the appropriate version");
        }
    }

    public void addKey(SshPrivateKey sshPrivateKey, SshPublicKey sshPublicKey, String string, KeyConstraints keyConstraints) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentAddKey(sshPrivateKey, sshPublicKey, string, keyConstraints);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (!(subsystemMessage instanceof SshAgentSuccess)) {
            throw new IOException("The key could not be added");
        }
    }

    public byte[] hashAndSign(SshPublicKey sshPublicKey, byte[] byArray) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentPrivateKeyOp(sshPublicKey, HASH_AND_SIGN, byArray);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (subsystemMessage instanceof SshAgentOperationComplete) {
            return ((SshAgentOperationComplete)subsystemMessage).getData();
        }
        throw new IOException("The operation failed");
    }

    public Map listKeys() throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentListKeys();
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (subsystemMessage instanceof SshAgentKeyList) {
            return ((SshAgentKeyList)subsystemMessage).getKeys();
        }
        throw new IOException("The agent responsed with an invalid message");
    }

    public boolean lockAgent(String string) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentLock(string);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        return subsystemMessage instanceof SshAgentSuccess;
    }

    public boolean unlockAgent(String string) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentUnlock(string);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        return subsystemMessage instanceof SshAgentSuccess;
    }

    public byte[] getRandomData(int n) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentRandom(n);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (subsystemMessage instanceof SshAgentRandomData) {
            return ((SshAgentRandomData)subsystemMessage).getRandomData();
        }
        throw new IOException("Agent failed to provide the request random data");
    }

    public void ping(byte[] byArray) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentPing(byArray);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (subsystemMessage instanceof SshAgentAlive) {
            if (!Arrays.equals(byArray, ((SshAgentAlive)subsystemMessage).getPadding())) {
                throw new IOException("Agent failed to reply with expected data");
            }
        } else {
            throw new IOException("Agent failed to provide the request random data");
        }
    }

    public void deleteKey(SshPublicKey sshPublicKey, String string) throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentDeleteKey(sshPublicKey, string);
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (!(subsystemMessage instanceof SshAgentSuccess)) {
            throw new IOException("The agent failed to delete the key");
        }
    }

    public void deleteAllKeys() throws IOException {
        SubsystemMessage subsystemMessage = new SshAgentDeleteAllKeys();
        this.sendMessage(subsystemMessage);
        subsystemMessage = this.readMessage();
        if (!(subsystemMessage instanceof SshAgentSuccess)) {
            throw new IOException("The agent failed to delete all keys");
        }
    }

    protected void sendForwardingNotice() throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        SshAgentForwardingNotice sshAgentForwardingNotice = new SshAgentForwardingNotice(inetAddress.getHostName(), inetAddress.getHostAddress(), 22);
        this.sendMessage(sshAgentForwardingNotice);
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) throws IOException {
        log.info((Object)"Sending message ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
        byte[] byArray = subsystemMessage.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(byArray.length));
        this.out.write(byArray);
        this.out.flush();
    }

    protected SubsystemMessage readMessage() throws InvalidMessageException {
        try {
            int n;
            byte[] byArray = new byte[4];
            for (n = 0; n < 3; n += this.in.read(byArray, n, byArray.length - n)) {
            }
            n = (int)ByteArrayReader.readInt(byArray, 0);
            byte[] byArray2 = new byte[n];
            for (n = 0; n < byArray2.length; n += this.in.read(byArray2, n, byArray2.length - n)) {
            }
            Integer n2 = new Integer(byArray2[0] & 0xFF);
            if (this.messages.containsKey(n2)) {
                Class clazz = (Class)this.messages.get(n2);
                SubsystemMessage subsystemMessage = (SubsystemMessage)clazz.newInstance();
                subsystemMessage.fromByteArray(byArray2);
                log.info((Object)"Received message ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
                SubsystemMessage subsystemMessage2 = subsystemMessage;
                return subsystemMessage2;
            }
            throw new InvalidMessageException("Unrecognised message id ".concat(String.valueOf(String.valueOf(n2.toString()))));
        }
        catch (Exception exception) {
            throw new InvalidMessageException(exception.getMessage());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

