/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

class SshAgentForwardingNotice
extends SubsystemMessage {
    public static final int SSH_AGENT_FORWARDING_NOTICE = 206;
    String remoteHostname;
    String remoteIPAddress;
    UnsignedInteger32 remotePort;

    public SshAgentForwardingNotice() {
        super(206);
    }

    public SshAgentForwardingNotice(String string, String string2, int n) {
        super(206);
        this.remoteHostname = string;
        this.remoteIPAddress = string2;
        this.remotePort = new UnsignedInteger32(n);
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public String getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public int getRemotePort() {
        return this.remotePort.intValue();
    }

    public String getMessageName() {
        return "SSH_AGENT_FORWARDING_NOTICE";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException, IOException {
        try {
            byteArrayWriter.writeString(this.remoteHostname);
            byteArrayWriter.writeString(this.remoteIPAddress);
            byteArrayWriter.writeUINT32(this.remotePort);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException, IOException {
        try {
            this.remoteHostname = byteArrayReader.readString();
            this.remoteIPAddress = byteArrayReader.readString();
            this.remotePort = byteArrayReader.readUINT32();
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }
}

