/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.KeyStore;
import com.sshtools.j2ssh.agent.SshAgentConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentSocketListener {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$agent$SshAgentSocketListener == null ? (class$com$sshtools$j2ssh$agent$SshAgentSocketListener = SshAgentSocketListener.class$("com.sshtools.j2ssh.agent.SshAgentSocketListener")) : class$com$sshtools$j2ssh$agent$SshAgentSocketListener));
    KeyStore keystore;
    ServerSocket server;
    int port;
    Thread thread;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentSocketListener;

    public SshAgentSocketListener(String string, KeyStore keyStore) throws AgentNotAvailableException {
        log.info((Object)"New SshAgent instance created");
        if (string == null) {
            throw new AgentNotAvailableException();
        }
        int n = string.indexOf(":");
        if (n == -1) {
            throw new AgentNotAvailableException();
        }
        String string2 = string.substring(0, n);
        this.port = Integer.parseInt(string.substring(n + 1));
        this.keystore = keyStore;
        try {
            this.server = new ServerSocket();
            this.server.bind(new InetSocketAddress(string2, this.port));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Socket socket;
                    while ((socket = SshAgentSocketListener.this.server.accept()) != null) {
                        SshAgentConnection sshAgentConnection = new SshAgentConnection(SshAgentSocketListener.this.keystore, socket.getInputStream(), socket.getOutputStream());
                    }
                    SshAgentSocketListener.this.thread = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.thread.start();
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected KeyStore getKeystore() {
        return this.keystore;
    }

    public static int configure() {
        return 49152 + (int)Math.round((double)16383.0f * Math.random());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-start")) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            SshAgentSocketListener sshAgentSocketListener = new SshAgentSocketListener(System.getProperty("sshtools.agent"), new KeyStore());
                            sshAgentSocketListener.start();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                thread.start();
            }
            if (stringArray[0].equals("-configure")) {
                System.out.println("SET SSHTOOLS_AGENT=localhost:".concat(String.valueOf(String.valueOf(String.valueOf(SshAgentSocketListener.configure())))));
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

