/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.util.DynamicClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationLoader {
    private static ConfigurationContext context = null;
    private static SecureRandom rnd;
    private static ClassLoader ext;
    private static ClassLoader clsLoader;
    private static Log log;
    private static String homedir;
    private static boolean initialized;
    private static Object initializationLock;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$ConfigurationLoader;

    public static SecureRandom getRND() {
        if (rnd == null) {
            rnd = new SecureRandom();
            rnd.nextInt();
        }
        return rnd;
    }

    public static String getVersionString(String string, String string2) {
        Properties properties = new Properties();
        String string3 = string;
        try {
            properties.load(ConfigurationLoader.loadFile(string2));
            String string4 = string.toLowerCase();
            String string5 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".version.major"));
            String string6 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".version.minor"));
            String string7 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".version.build"));
            String string8 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".project.type"));
            if (string5 != null && string6 != null && string7 != null) {
                string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" ").append(string5).append(".").append(string6).append(".").append(string7))))));
            }
            if (string8 != null) {
                string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(string8))))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public static String checkAndGetProperty(String string, String string2) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PropertyPermission(string, "read"));
            }
            String string3 = System.getProperty(string, string2);
            return string3;
        }
        catch (AccessControlException accessControlException) {
            String string4 = string2;
            return string4;
        }
    }

    public static void initialize(boolean bl) throws ConfigurationException {
        ConfigurationLoader.initialize(bl, new DefaultConfigurationContext());
    }

    public static void initialize(boolean bl, ConfigurationContext configurationContext) throws ConfigurationException {
        Object object = initializationLock;
        synchronized (object) {
            if (initialized && !bl) {
                return;
            }
            configurationContext.initialize();
            context = configurationContext;
            try {
                File file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(homedir))).append("lib").append(File.separator).append("ext"))));
                FilenameFilter filenameFilter = new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                };
                File[] fileArray = file.listFiles(filenameFilter);
                Vector<String> vector = new Vector<String>();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Extension ").append(fileArray[i].getAbsolutePath()).append(" being added to classpath"))));
                        vector.add(fileArray[i].getAbsolutePath());
                    }
                }
                ext = new DynamicClassLoader((class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader).getClassLoader(), vector);
            }
            catch (AccessControlException accessControlException) {
                log.info((Object)"Cannot access lib/ext directory, extension classes will not be loaded");
            }
            initialized = true;
        }
    }

    public static boolean isConfigurationAvailable(Class clazz) throws ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (context != null) {
            return context.isConfigurationAvailable(clazz);
        }
        return false;
    }

    public static Object getConfiguration(Class clazz) throws ConfigurationException {
        if (context != null && context.isConfigurationAvailable(clazz)) {
            return context.getConfiguration(clazz);
        }
        throw new ConfigurationException(String.valueOf(String.valueOf(new StringBuffer("No ").append(clazz.getName()).append(" configuration is available in this context"))));
    }

    public static String getConfigurationDirectory() {
        return String.valueOf(String.valueOf(homedir)).concat("conf/");
    }

    public static Class getExtensionClass(String string) throws ConfigurationException, ClassNotFoundException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (ext == null) {
            throw new ClassNotFoundException("Configuration not initialized");
        }
        return ext.loadClass(string);
    }

    public static String getHomeDirectory() {
        return homedir;
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        clsLoader = classLoader;
    }

    public static ClassLoader getContextClassLoader() {
        return clsLoader;
    }

    public static boolean isContextClassLoader() {
        return clsLoader != null;
    }

    public static void setHomeDirectory(String string) {
        if ((homedir = homedir.replace('\\', '/')).endsWith("/")) {
            homedir = String.valueOf(String.valueOf(homedir)).concat("/");
        }
    }

    public static InputStream loadFile(String string) throws FileNotFoundException {
        log.info((Object)"Attempting to load ".concat(String.valueOf(String.valueOf(string))));
        try {
            FileInputStream fileInputStream;
            FileInputStream fileInputStream2 = fileInputStream = new FileInputStream(String.valueOf(String.valueOf(ConfigurationLoader.getConfigurationDirectory())).concat(String.valueOf(String.valueOf(string))));
            return fileInputStream2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info((Object)"Failed to load file from configuration directory, trying SSHTools home");
            try {
                FileInputStream fileInputStream;
                FileInputStream fileInputStream3 = fileInputStream = new FileInputStream(String.valueOf(String.valueOf(homedir)).concat(String.valueOf(String.valueOf(string))));
                return fileInputStream3;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                log.info((Object)"Failed to load file from SSHTools home directory, trying as absolute path");
                FileInputStream fileInputStream = new FileInputStream(string);
                return fileInputStream;
            }
        }
    }

    public static OutputStream saveFile(String string) throws FileNotFoundException {
        File file = new File(String.valueOf(String.valueOf(ConfigurationLoader.getConfigurationDirectory())).concat(String.valueOf(String.valueOf(string))));
        if (file.exists()) {
            return new FileOutputStream(file);
        }
        file = new File(string);
        if (file.exists()) {
            return new FileOutputStream(string);
        }
        return new FileOutputStream(string.indexOf(File.pathSeparator) >= 0 ? string : String.valueOf(String.valueOf(ConfigurationLoader.getConfigurationDirectory())).concat(String.valueOf(String.valueOf(string))));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        clsLoader = null;
        log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader));
        initialized = false;
        initializationLock = new Object();
        homedir = ConfigurationLoader.checkAndGetProperty("sshtools.home", System.getProperty("java.home"));
        if (homedir != null && !homedir.endsWith(File.separator)) {
            homedir = String.valueOf(String.valueOf(homedir)).concat(String.valueOf(String.valueOf(File.separator)));
        }
    }

    static class DefaultConfigurationContext
    implements ConfigurationContext {
        DefaultConfigurationContext() {
        }

        public void initialize() throws ConfigurationException {
        }

        public boolean isConfigurationAvailable(Class clazz) {
            return false;
        }

        public Object getConfiguration(Class clazz) throws ConfigurationException {
            throw new ConfigurationException("Default configuration does not contain ".concat(String.valueOf(String.valueOf(clazz.getName()))));
        }
    }
}

