/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Channel {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$connection$Channel == null ? (class$com$sshtools$j2ssh$connection$Channel = Channel.class$("com.sshtools.j2ssh.connection.Channel")) : class$com$sshtools$j2ssh$connection$Channel));
    protected ChannelDataWindow localWindow = new ChannelDataWindow();
    protected ChannelDataWindow remoteWindow = new ChannelDataWindow();
    protected ConnectionProtocol connection;
    protected Map nativeSettings;
    protected SshMessageStore incoming = new SshMessageStore();
    protected long localChannelId;
    protected long localPacketSize;
    protected long remoteChannelId;
    protected long remotePacketSize;
    protected ChannelInputStream in;
    protected ChannelOutputStream out;
    protected ChannelState state = new ChannelState();
    private boolean isClosed = false;
    private boolean isLocalEOF = false;
    private boolean isRemoteEOF = false;
    private OutputStream bout = null;
    private InputStream bin = null;
    private IOStreamConnector ios = null;
    private Vector eventListeners = new Vector();
    private Channel boundChannel = null;
    private int seqIn = 0;
    private int seqOut = 0;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$Channel;

    public Channel() {
        this.localPacketSize = this.getMaximumPacketSize();
        this.localWindow.increaseWindowSpace(this.getMaximumWindowSpace());
    }

    public abstract byte[] getChannelOpenData();

    public abstract byte[] getChannelConfirmationData();

    public abstract String getChannelType();

    protected abstract int getMinimumWindowSpace();

    protected abstract int getMaximumWindowSpace();

    protected abstract int getMaximumPacketSize();

    public void bindOutputStream(OutputStream outputStream) throws IOException {
        SshMessageStore sshMessageStore = this.incoming;
        synchronized (sshMessageStore) {
            this.bout = outputStream;
            if (this.state.getValue() == 2) {
                this.sendOutstandingMessages();
            }
        }
    }

    public void bindInputStream(InputStream inputStream) throws IOException {
        this.bin = inputStream;
        this.ios = new IOStreamConnector();
        if (this.state.getValue() == 2) {
            this.ios.connect(inputStream, this.out);
        }
    }

    public void bindChannel(Channel channel) throws IOException {
        this.boundChannel = channel;
        if (channel.getState().getValue() == 2) {
            throw new IOException("You cannot bind to an open channel");
        }
        channel.addEventListener(new ChannelEventListener(){

            public void onChannelOpen(Channel channel) {
                try {
                    Channel.this.bindOutputStream(channel.getOutputStream());
                    channel.bindOutputStream(Channel.this.getOutputStream());
                }
                catch (IOException iOException) {
                    log.info((Object)"Failed to bind the channel");
                }
            }

            public void onChannelEOF(Channel channel) {
            }

            public void onChannelClose(Channel channel) {
                try {
                    Channel.this.close();
                }
                catch (IOException iOException) {
                    log.info((Object)"Failed to close the channel");
                }
            }

            public void onDataReceived(Channel channel, byte[] byArray) {
            }

            public void onDataSent(Channel channel, byte[] byArray) {
            }
        });
    }

    public void onChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        if (!this.isClosed()) {
            if (sshMsgChannelData.getChannelDataLength() > this.localWindow.getWindowSpace()) {
                throw new IOException("More data recieved than is allowed by the channel data window");
            }
            long l = this.localWindow.consumeWindowSpace(sshMsgChannelData.getChannelData().length);
            if (l < (long)this.getMinimumWindowSpace()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Channel ").append(String.valueOf(this.localChannelId)).append(" requires more window space"))));
                }
                l = (long)this.getMaximumWindowSpace() - l;
                this.connection.sendChannelWindowAdjust(this, l);
                this.localWindow.increaseWindowSpace(l);
            }
            SshMessageStore sshMessageStore = this.incoming;
            synchronized (sshMessageStore) {
                ++this.seqIn;
                if (this.bout != null) {
                    ++this.seqOut;
                    try {
                        this.bout.write(sshMsgChannelData.getChannelData());
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"Could not route data to the bound OutputStream.", (Throwable)iOException);
                        this.close();
                    }
                } else {
                    this.incoming.addMessage(sshMsgChannelData);
                }
            }
            Iterator iterator = ((AbstractList)this.eventListeners).iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataReceived(this, sshMsgChannelData.getChannelData());
            }
        } else {
            throw new IOException("Channel data received but channel is closed");
        }
    }

    public boolean isClosed() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            boolean bl = this.state.getValue() == 3;
            return bl;
        }
    }

    protected void sendChannelData(byte[] byArray) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelData(this, byArray);
            Iterator iterator = ((AbstractList)this.eventListeners).iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, byArray);
            }
        } else {
            throw new IOException("The channel is closed");
        }
    }

    protected void sendChannelExtData(int n, byte[] byArray) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelExtData(this, n, byArray);
            Iterator iterator = ((AbstractList)this.eventListeners).iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, byArray);
            }
        } else {
            throw new IOException("The channel is closed");
        }
    }

    public void onChannelExtData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        if ((long)sshMsgChannelExtendedData.getChannelData().length > this.localWindow.getWindowSpace()) {
            throw new IOException("More data recieved than is allowed by the channel data window");
        }
        long l = this.localWindow.consumeWindowSpace(sshMsgChannelExtendedData.getChannelData().length);
        if (l < (long)this.getMinimumWindowSpace()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Channel ").append(String.valueOf(this.localChannelId)).append(" requires more window space"))));
            }
            l = (long)this.getMaximumWindowSpace() - l;
            this.connection.sendChannelWindowAdjust(this, l);
            this.localWindow.increaseWindowSpace(l);
        }
        this.incoming.addMessage(sshMsgChannelExtendedData);
        Iterator iterator = ((AbstractList)this.eventListeners).iterator();
        while (iterator.hasNext()) {
            ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
            if (channelEventListener == null) continue;
            channelEventListener.onDataReceived(this, sshMsgChannelExtendedData.getChannelData());
        }
    }

    public ChannelInputStream getInputStream() {
        return this.in;
    }

    public long getLocalChannelId() {
        return this.localChannelId;
    }

    public long getLocalPacketSize() {
        return this.localPacketSize;
    }

    public synchronized ChannelDataWindow getLocalWindow() {
        return this.localWindow;
    }

    public ChannelOutputStream getOutputStream() {
        return this.out;
    }

    public long getRemoteChannelId() {
        return this.remoteChannelId;
    }

    public long getRemotePacketSize() {
        return this.remotePacketSize;
    }

    public synchronized ChannelDataWindow getRemoteWindow() {
        return this.remoteWindow;
    }

    public ChannelState getState() {
        return this.state;
    }

    public void close() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(3);
            this.onChannelClose();
            this.in.close();
            this.out.close();
            if (this.ios != null) {
                this.ios.close();
            }
            if (this.connection != null) {
                this.connection.closeChannel(this);
            }
            Iterator iterator = ((AbstractList)this.eventListeners).iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelClose(this);
            }
        }
    }

    protected void onOutputStreamEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (this.state.getValue() == 2 && this.connection.isConnected()) {
                this.connection.sendChannelEOF(this);
            }
        }
    }

    protected void onInputStreamEOF() throws IOException {
        Iterator iterator = ((AbstractList)this.eventListeners).iterator();
        while (iterator.hasNext()) {
            ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
            if (channelEventListener == null) continue;
            channelEventListener.onChannelClose(this);
        }
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.in.close();
        }
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.eventListeners.add(channelEventListener);
    }

    public void init(ConnectionProtocol connectionProtocol, long l, long l2, long l3, long l4) throws IOException {
        this.localChannelId = l;
        this.remoteChannelId = l2;
        this.remotePacketSize = l4;
        this.remoteWindow.increaseWindowSpace(l3);
        this.connection = connectionProtocol;
        this.nativeSettings = this.nativeSettings;
        this.in = new ChannelInputStream(this.incoming);
        this.out = new ChannelOutputStream(this);
        this.state.setValue(2);
    }

    protected void open() throws IOException {
        this.state.setValue(2);
        this.onChannelOpen();
        Iterator iterator = ((AbstractList)this.eventListeners).iterator();
        while (iterator.hasNext()) {
            ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
            if (channelEventListener == null) continue;
            channelEventListener.onChannelOpen(this);
        }
        if (this.bout != null) {
            this.sendOutstandingMessages();
        }
        if (this.bin != null && this.ios == null) {
            this.ios.connect(this.bin, this.out);
        }
    }

    private void sendOutstandingMessages() throws IOException {
        if (this.bout != null && this.incoming.hasMessages()) {
            try {
                while (true) {
                    SshMsgChannelData sshMsgChannelData = (SshMsgChannelData)this.incoming.peekMessage(94);
                    this.incoming.removeMessage(sshMsgChannelData);
                    ++this.seqOut;
                    try {
                        this.bout.write(sshMsgChannelData.getChannelData());
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"Could not write outstanding messages to the bound OutputStream", (Throwable)iOException);
                        this.close();
                    }
                }
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted");
            }
        }
    }

    public void init(ConnectionProtocol connectionProtocol, long l, long l2, long l3, long l4, ChannelEventListener channelEventListener) throws IOException {
        if (channelEventListener != null) {
            this.addEventListener(channelEventListener);
        }
        this.init(connectionProtocol, l, l2, l3, l4);
    }

    protected abstract void onChannelClose() throws IOException;

    protected abstract void onChannelOpen() throws IOException;

    protected abstract void onChannelRequest(String var1, boolean var2, byte[] var3) throws IOException;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

