/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import java.io.IOException;
import java.io.OutputStream;

public class ChannelOutputStream
extends OutputStream {
    private Channel channel;
    private boolean isClosed = false;
    private Integer type = null;

    public ChannelOutputStream(Channel channel, Integer n) {
        this.channel = channel;
        this.type = n;
    }

    public ChannelOutputStream(Channel channel) {
        this(channel, null);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.channel.onOutputStreamEOF();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("The ChannelOutputStream is closed!");
        }
        byte[] byArray2 = null;
        if (n > 0 || n2 < byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        } else {
            byArray2 = byArray;
        }
        this.sendChannelData(byArray2);
    }

    public void write(int n) throws IOException {
        if (this.isClosed) {
            throw new IOException("The ChannelOutputStream is closed!");
        }
        byte[] byArray = new byte[]{(byte)n};
        this.sendChannelData(byArray);
    }

    private void sendChannelData(byte[] byArray) throws IOException {
        int n;
        ChannelDataWindow channelDataWindow = this.channel.getRemoteWindow();
        for (int i = 0; i < byArray.length; i += n) {
            int n2 = byArray.length - i;
            long l = channelDataWindow.getWindowSpace() < this.channel.getRemotePacketSize() ? channelDataWindow.getWindowSpace() : this.channel.getRemotePacketSize();
            n = l < (long)n2 ? (int)l : n2;
            this.channel.remoteWindow.consumeWindowSpace(n);
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, i, byArray2, 0, n);
            if (this.type != null) {
                this.channel.sendChannelExtData(this.type, byArray2);
                continue;
            }
            this.channel.sendChannelData(byArray2);
        }
    }
}

