/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelClose;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelEOF;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.connection.SshMsgChannelFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelOpen;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelRequest;
import com.sshtools.j2ssh.connection.SshMsgChannelSuccess;
import com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.sshtools.j2ssh.connection.SshMsgGlobalRequest;
import com.sshtools.j2ssh.connection.SshMsgRequestFailure;
import com.sshtools.j2ssh.connection.SshMsgRequestSuccess;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionProtocol
extends AsyncService {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$connection$ConnectionProtocol == null ? (class$com$sshtools$j2ssh$connection$ConnectionProtocol = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.ConnectionProtocol")) : class$com$sshtools$j2ssh$connection$ConnectionProtocol));
    private Map activeChannels = new HashMap();
    private Map allowedChannels = new HashMap();
    private Map globalRequests = new HashMap();
    private long nextChannelId = 0L;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$ConnectionProtocol;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelClose;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelData;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelEOF;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelOpen;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelRequest;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgRequestFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess;

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String string, ChannelFactory channelFactory) throws IOException {
        this.allowedChannels.put(string, channelFactory);
    }

    public void removeChannelFactory(String string) {
        this.allowedChannels.remove(string);
    }

    public boolean containsChannelFactory(String string) {
        return this.allowedChannels.containsKey(string);
    }

    public void allowGlobalRequest(String string, GlobalRequestHandler globalRequestHandler) {
        this.globalRequests.put(string, globalRequestHandler);
    }

    public synchronized boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3;
    }

    public synchronized boolean openChannel(Channel channel, ChannelEventListener channelEventListener) throws IOException {
        long l = this.nextChannelId++;
        Map map = this.activeChannels;
        synchronized (map) {
            SshMsgChannelOpen sshMsgChannelOpen = new SshMsgChannelOpen(channel.getChannelType(), l, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
            this.transport.sendMessage(sshMsgChannelOpen, this);
            int[] nArray = new int[]{91, 92};
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                if (sshMessage.getMessageId() == 91) {
                    SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = (SshMsgChannelOpenConfirmation)sshMessage;
                    this.activeChannels.put(new Long(l), channel);
                    log.debug((Object)"Initiating channel");
                    channel.init(this, l, sshMsgChannelOpenConfirmation.getSenderChannel(), sshMsgChannelOpenConfirmation.getInitialWindowSize(), sshMsgChannelOpenConfirmation.getMaximumPacketSize(), channelEventListener);
                    channel.open();
                    log.info((Object)"Channel is open");
                    boolean bl = true;
                    return bl;
                }
                channel.getState().setValue(3);
                boolean bl = false;
                return bl;
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                throw new IOException(messageStoreEOFException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
    }

    protected void onStop() {
    }

    public synchronized void sendChannelData(Channel channel, byte[] byArray) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Sending ").append(String.valueOf(byArray.length)).append(" bytes for channel id ").append(String.valueOf(channel.getLocalChannelId())))));
        }
        SshMsgChannelData sshMsgChannelData = new SshMsgChannelData(channel.getRemoteChannelId(), byArray);
        this.transport.sendMessage(sshMsgChannelData, this);
    }

    public synchronized void sendChannelEOF(Channel channel) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            if (!this.activeChannels.containsValue(channel)) {
                throw new IOException("Attempt to send EOF for a non existent channel ".concat(String.valueOf(String.valueOf(String.valueOf(channel.getLocalChannelId())))));
            }
            SshMsgChannelEOF sshMsgChannelEOF = new SshMsgChannelEOF(channel.getRemoteChannelId());
            this.transport.sendMessage(sshMsgChannelEOF, this);
        }
    }

    public synchronized void sendChannelExtData(Channel channel, int n, byte[] byArray) throws IOException {
        channel.getRemoteWindow().consumeWindowSpace(byArray.length);
        SshMsgChannelExtendedData sshMsgChannelExtendedData = new SshMsgChannelExtendedData(channel.getRemoteChannelId(), n, byArray);
        this.transport.sendMessage(sshMsgChannelExtendedData, this);
    }

    public synchronized boolean sendChannelRequest(Channel channel, String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Sending ").append(string).append(" request for the ").append(channel.getChannelType()).append(" channel"))));
        SshMsgChannelRequest sshMsgChannelRequest = new SshMsgChannelRequest(channel.getRemoteChannelId(), string, bl, byArray);
        this.transport.sendMessage(sshMsgChannelRequest, this);
        if (bl) {
            int[] nArray = new int[]{99, 100};
            log.debug((Object)"Waiting for channel request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 99: {
                        log.debug((Object)"Channel request succeeded");
                        bl2 = true;
                        break;
                    }
                    case 100: {
                        log.debug((Object)"Channel request failed");
                        bl2 = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return bl2;
    }

    public synchronized void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    public synchronized void sendChannelRequestSuccess(Channel channel) throws IOException {
        SshMsgChannelSuccess sshMsgChannelSuccess = new SshMsgChannelSuccess(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelSuccess, this);
    }

    public synchronized void sendChannelWindowAdjust(Channel channel, long l) throws IOException {
        SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), l);
        this.transport.sendMessage(sshMsgChannelWindowAdjust, this);
    }

    public synchronized boolean sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        SshMsgGlobalRequest sshMsgGlobalRequest = new SshMsgGlobalRequest(string, true, byArray);
        this.transport.sendMessage(sshMsgGlobalRequest, this);
        if (bl) {
            int[] nArray = new int[]{81, 82};
            log.debug((Object)"Waiting for global request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 81: {
                        log.debug((Object)"Global request succeeded");
                        bl2 = true;
                        break;
                    }
                    case 82: {
                        log.debug((Object)"Global request failed");
                        bl2 = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return bl2;
    }

    protected int[] getAsyncMessageFilter() {
        int[] nArray = new int[10];
        nArray[0] = 80;
        nArray[3] = 90;
        nArray[4] = 97;
        nArray[5] = 96;
        nArray[6] = 95;
        nArray[7] = 94;
        nArray[8] = 98;
        nArray[9] = 93;
        return nArray;
    }

    protected synchronized void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose sshMsgChannelClose = new SshMsgChannelClose(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelClose, this);
    }

    protected void onGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Processing ").append(string).append(" global request"))));
        if (!this.globalRequests.containsKey(string)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler globalRequestHandler = (GlobalRequestHandler)this.globalRequests.get(string);
            GlobalRequestResponse globalRequestResponse = globalRequestHandler.processGlobalRequest(string, byArray);
            if (bl) {
                if (globalRequestResponse.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(globalRequestResponse.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    protected void onMessageReceived(SshMessage sshMessage) throws IOException {
        switch (sshMessage.getMessageId()) {
            case 80: {
                this.onMsgGlobalRequest((SshMsgGlobalRequest)sshMessage);
                break;
            }
            case 90: {
                this.onMsgChannelOpen((SshMsgChannelOpen)sshMessage);
                break;
            }
            case 97: {
                this.onMsgChannelClose((SshMsgChannelClose)sshMessage);
                break;
            }
            case 96: {
                this.onMsgChannelEOF((SshMsgChannelEOF)sshMessage);
                break;
            }
            case 94: {
                this.onMsgChannelData((SshMsgChannelData)sshMessage);
                break;
            }
            case 95: {
                this.onMsgChannelExtendedData((SshMsgChannelExtendedData)sshMessage);
                break;
            }
            case 98: {
                this.onMsgChannelRequest((SshMsgChannelRequest)sshMessage);
                break;
            }
            case 93: {
                this.onMsgChannelWindowAdjust((SshMsgChannelWindowAdjust)sshMessage);
                break;
            }
            default: {
                log.debug((Object)"Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    protected void onServiceAccept() {
    }

    protected void onServiceInit(int n) throws IOException {
        log.info((Object)"Registering connection protocol messages");
        this.messageStore.registerMessage(91, class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation")) : class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation);
        this.messageStore.registerMessage(92, class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure")) : class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure);
        this.messageStore.registerMessage(90, class$com$sshtools$j2ssh$connection$SshMsgChannelOpen == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelOpen = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelOpen")) : class$com$sshtools$j2ssh$connection$SshMsgChannelOpen);
        this.messageStore.registerMessage(97, class$com$sshtools$j2ssh$connection$SshMsgChannelClose == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelClose = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelClose")) : class$com$sshtools$j2ssh$connection$SshMsgChannelClose);
        this.messageStore.registerMessage(96, class$com$sshtools$j2ssh$connection$SshMsgChannelEOF == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelEOF = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelEOF")) : class$com$sshtools$j2ssh$connection$SshMsgChannelEOF);
        this.messageStore.registerMessage(94, class$com$sshtools$j2ssh$connection$SshMsgChannelData == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelData = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelData")) : class$com$sshtools$j2ssh$connection$SshMsgChannelData);
        this.messageStore.registerMessage(95, class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelExtendedData")) : class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData);
        this.messageStore.registerMessage(100, class$com$sshtools$j2ssh$connection$SshMsgChannelFailure == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelFailure = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelFailure")) : class$com$sshtools$j2ssh$connection$SshMsgChannelFailure);
        this.messageStore.registerMessage(98, class$com$sshtools$j2ssh$connection$SshMsgChannelRequest == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelRequest = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelRequest")) : class$com$sshtools$j2ssh$connection$SshMsgChannelRequest);
        this.messageStore.registerMessage(99, class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelSuccess")) : class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess);
        this.messageStore.registerMessage(93, class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust")) : class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust);
        this.messageStore.registerMessage(80, class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest == null ? (class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgGlobalRequest")) : class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest);
        this.messageStore.registerMessage(82, class$com$sshtools$j2ssh$connection$SshMsgRequestFailure == null ? (class$com$sshtools$j2ssh$connection$SshMsgRequestFailure = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgRequestFailure")) : class$com$sshtools$j2ssh$connection$SshMsgRequestFailure);
        this.messageStore.registerMessage(81, class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess == null ? (class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgRequestSuccess")) : class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess);
    }

    protected void onServiceRequest() {
    }

    protected void sendChannelFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(sshMsgChannelOpenConfirmation, this);
    }

    protected void sendChannelOpenFailure(long l, long l2, String string, String string2) throws IOException {
        SshMsgChannelOpenFailure sshMsgChannelOpenFailure = new SshMsgChannelOpenFailure(l, l2, string, string2);
        this.transport.sendMessage(sshMsgChannelOpenFailure, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure sshMsgRequestFailure = new SshMsgRequestFailure();
        this.transport.sendMessage(sshMsgRequestFailure, this);
    }

    protected void sendGlobalRequestSuccess(byte[] byArray) throws IOException {
        SshMsgRequestSuccess sshMsgRequestSuccess = new SshMsgRequestSuccess(byArray);
        this.transport.sendMessage(sshMsgRequestSuccess, this);
    }

    private Channel getChannel(long l) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            Long l2 = new Long(l);
            if (!this.activeChannels.containsKey(l2)) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Non existent channel ").append(l2.toString()).append(" requested"))));
            }
            Channel channel = (Channel)this.activeChannels.get(l2);
            return channel;
        }
    }

    private void onMsgChannelClose(SshMsgChannelClose sshMsgChannelClose) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelClose.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to close a non existent channel!");
        }
        if (channel.getState().getValue() != 3) {
            channel.close();
        }
        this.removeChannel(channel);
    }

    private void onMsgChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        Channel channel;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Received ").append(String.valueOf(sshMsgChannelData.getChannelData().length)).append(" bytes of data for channel id ").append(String.valueOf(sshMsgChannelData.getRecipientChannel())))));
        }
        if ((channel = this.getChannel(sshMsgChannelData.getRecipientChannel())) == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.onChannelData(sshMsgChannelData);
    }

    private void onMsgChannelEOF(SshMsgChannelEOF sshMsgChannelEOF) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelEOF.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote side tried to set a non existent channel to EOF!");
        }
        try {
            channel.onInputStreamEOF();
        }
        catch (IOException iOException) {
            throw new IOException("Failed to close the ChannelInputStream");
        }
    }

    private void onMsgChannelExtendedData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelExtendedData.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.getLocalWindow().consumeWindowSpace(sshMsgChannelExtendedData.getChannelData().length);
        channel.incoming.addMessage(sshMsgChannelExtendedData);
    }

    private void onMsgChannelOpen(SshMsgChannelOpen sshMsgChannelOpen) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            ChannelFactory channelFactory = (ChannelFactory)this.allowedChannels.get(sshMsgChannelOpen.getChannelType());
            if (channelFactory == null) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, "The channel type is not supported", "");
                log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Request for channel type ").append(sshMsgChannelOpen.getChannelType()).append(" refused"))));
                return;
            }
            try {
                Channel channel = channelFactory.createChannel(sshMsgChannelOpen.getChannelType(), sshMsgChannelOpen.getChannelData());
                channel.init(this, this.nextChannelId++, sshMsgChannelOpen.getSenderChannelId(), sshMsgChannelOpen.getInitialWindowSize(), sshMsgChannelOpen.getMaximumPacketSize());
                this.activeChannels.put(new Long(channel.getLocalChannelId()), channel);
                this.sendChannelOpenConfirmation(channel);
                channel.open();
            }
            catch (InvalidChannelException invalidChannelException) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, invalidChannelException.getMessage(), "");
            }
        }
    }

    private void onMsgChannelRequest(SshMsgChannelRequest sshMsgChannelRequest) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelRequest.getRecipientChannel());
        if (channel == null) {
            log.warn((Object)"Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(sshMsgChannelRequest.getRequestType(), sshMsgChannelRequest.getWantReply(), sshMsgChannelRequest.getChannelData());
    }

    private void onMsgChannelWindowAdjust(SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelWindowAdjust.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to increase window space for a non existent channel!");
        }
        channel.getRemoteWindow().increaseWindowSpace(sshMsgChannelWindowAdjust.getBytesToAdd());
        log.debug((Object)String.valueOf(String.valueOf(String.valueOf(sshMsgChannelWindowAdjust.getBytesToAdd()))).concat(" bytes added to remote window"));
        log.debug((Object)"Remote window space is ".concat(String.valueOf(String.valueOf(String.valueOf(channel.getRemoteWindow().getWindowSpace())))));
    }

    private void onMsgGlobalRequest(SshMsgGlobalRequest sshMsgGlobalRequest) throws IOException {
        this.onGlobalRequest(sshMsgGlobalRequest.getRequestName(), sshMsgGlobalRequest.getWantReply(), sshMsgGlobalRequest.getRequestData());
    }

    private void removeChannel(Channel channel) {
        Map map = this.activeChannels;
        synchronized (map) {
            this.activeChannels.remove(new Long(channel.getLocalChannelId()));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

