/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayWriter
extends ByteArrayOutputStream {
    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeBinaryString(byte[] byArray) throws IOException {
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeInt(long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        this.write(byArray);
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        this.write(byArray);
    }

    public static byte[] encodeInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public void writeUINT32(UnsignedInteger32 unsignedInteger32) throws IOException {
        this.writeInt(unsignedInteger32.longValue());
    }

    public void writeUINT64(UnsignedInteger64 unsignedInteger64) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = unsignedInteger64.bigIntValue().toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        this.write(byArray);
    }

    public static void writeIntToArray(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length - n < 4) {
            throw new IOException("Not enough data in array to write integer at position ".concat(String.valueOf(String.valueOf(String.valueOf(n)))));
        }
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeInt(0);
        } else {
            this.writeInt(string.length());
            this.write(string.getBytes("US-ASCII"));
        }
    }
}

