/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.net;

import com.sshtools.j2ssh.net.TransportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SocksProxySocket
extends Socket
implements TransportProvider {
    public static final int SOCKS4 = 4;
    public static final int SOCKS5 = 5;
    private static final int CONNECT = 1;
    private static final int NULL_TERMINATION = 0;
    private static final String[] SOCKSV5_ERROR = new String[]{"Success", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    private static final String[] SOCKSV4_ERROR = new String[]{"Request rejected or failed", "SOCKS server cannot connect to identd on the client", "The client program and identd report different user-ids"};
    private String proxyHost;
    private int proxyPort;
    private String remoteHost;
    private int remotePort;
    private String providerDetail;

    private SocksProxySocket(String string, int n, String string2, int n2) throws UnknownHostException, IOException {
        super(string2, n2);
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.remoteHost = string;
        this.remotePort = n;
    }

    public static SocksProxySocket connectViaSocks4Proxy(String string, int n, String string2, int n2, String string3) throws UnknownHostException, IOException {
        SocksProxySocket socksProxySocket = new SocksProxySocket(string, n, string2, n2);
        try {
            InputStream inputStream = socksProxySocket.getInputStream();
            OutputStream outputStream = socksProxySocket.getOutputStream();
            InetAddress inetAddress = InetAddress.getByName(string);
            outputStream.write(4);
            outputStream.write(1);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.write(inetAddress.getAddress());
            outputStream.write(string3.getBytes());
            outputStream.write(0);
            outputStream.flush();
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("SOCKS4 server ").append(string2).append(":").append(n2).append(" disconnected"))));
            }
            if (n3 != 0) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Invalid response from SOCKS4 server (").append(n3).append(") ").append(string2).append(":").append(n2))));
            }
            int n4 = inputStream.read();
            if (n4 != 90) {
                if (n4 > 90 && n4 < 93) {
                    throw new IOException("SOCKS4 server unable to connect, reason: ".concat(String.valueOf(String.valueOf(SOCKSV4_ERROR[n4 - 91]))));
                }
                throw new IOException("SOCKS4 server unable to connect, reason: ".concat(String.valueOf(String.valueOf(n4))));
            }
            byte[] byArray = new byte[6];
            if (inputStream.read(byArray, 0, 6) != 6) {
                throw new IOException("SOCKS4 error reading destination address/port");
            }
            socksProxySocket.providerDetail = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(byArray[2]))).append(".").append(byArray[3]).append(".").append(byArray[4]).append(".").append(byArray[5]).append(":").append(byArray[0] << 8 | byArray[1])));
        }
        catch (SocketException socketException) {
            throw new SocketException(String.valueOf(String.valueOf(new StringBuffer("Error communicating with SOCKS4 server ").append(string2).append(":").append(n2).append(", ").append(socketException.getMessage()))));
        }
        return socksProxySocket;
    }

    public static SocksProxySocket connectViaSocks5Proxy(String string, int n, String string2, int n2, boolean bl, String string3, String string4) throws UnknownHostException, IOException {
        SocksProxySocket socksProxySocket = new SocksProxySocket(string, n, string2, n2);
        try {
            InputStream inputStream = socksProxySocket.getInputStream();
            OutputStream outputStream = socksProxySocket.getOutputStream();
            byte[] byArray = new byte[]{5, 2, 0, 2};
            byte[] byArray2 = new byte[2];
            outputStream.write(byArray);
            outputStream.flush();
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("SOCKS5 server ").append(string2).append(":").append(n2).append(" disconnected"))));
            }
            if (n3 != 5) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Invalid response from SOCKS5 server (").append(n3).append(") ").append(string2).append(":").append(n2))));
            }
            int n4 = inputStream.read();
            switch (n4) {
                case 0: {
                    break;
                }
                case 2: {
                    SocksProxySocket.performAuthentication(inputStream, outputStream, string3, string4, string2, n2);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 server does not support our authentication methods");
                }
            }
            if (bl) {
                InetAddress inetAddress;
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Can't do local lookup on: ").append(string).append(", try socks5 without local lookup"))));
                }
                byArray = new byte[]{5, 1, 0, 1};
                outputStream.write(byArray);
                outputStream.write(inetAddress.getAddress());
            } else {
                byArray = new byte[]{5, 1, 0, 3};
                outputStream.write(byArray);
                outputStream.write(string.length());
                outputStream.write(string.getBytes());
            }
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.flush();
            n3 = inputStream.read();
            if (n3 != 5) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Invalid response from SOCKS5 server (").append(n3).append(") ").append(string2).append(":").append(n2))));
            }
            int n5 = inputStream.read();
            if (n5 != 0) {
                if (n5 > 0 && n5 < 9) {
                    throw new IOException("SOCKS5 server unable to connect, reason: ".concat(String.valueOf(String.valueOf(SOCKSV5_ERROR[n5]))));
                }
                throw new IOException("SOCKS5 server unable to connect, reason: ".concat(String.valueOf(String.valueOf(n5))));
            }
            inputStream.read();
            int n6 = inputStream.read();
            byte[] byArray3 = new byte[255];
            switch (n6) {
                case 1: {
                    if (inputStream.read(byArray3, 0, 4) != 4) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    socksProxySocket.providerDetail = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(byArray3[0]))).append(".").append(byArray3[1]).append(".").append(byArray3[2]).append(".").append(byArray3[3])));
                    break;
                }
                case 3: {
                    int n7 = inputStream.read();
                    if (inputStream.read(byArray3, 0, n7) != n7) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    socksProxySocket.providerDetail = new String(byArray3);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 gave unsupported address type: ".concat(String.valueOf(String.valueOf(n6))));
                }
            }
            if (inputStream.read(byArray3, 0, 2) != 2) {
                throw new IOException("SOCKS5 error reading port");
            }
            socksProxySocket.providerDetail = String.valueOf(String.valueOf(socksProxySocket.providerDetail)).concat(String.valueOf(String.valueOf(":".concat(String.valueOf(String.valueOf(byArray3[0] << 8 | byArray3[1]))))));
        }
        catch (SocketException socketException) {
            throw new SocketException(String.valueOf(String.valueOf(new StringBuffer("Error communicating with SOCKS5 server ").append(string2).append(":").append(n2).append(", ").append(socketException.getMessage()))));
        }
        return socksProxySocket;
    }

    public String getProviderDetail() {
        return this.providerDetail;
    }

    private static void performAuthentication(InputStream inputStream, OutputStream outputStream, String string, String string2, String string3, int n) throws IOException {
        outputStream.write(1);
        outputStream.write(string.length());
        outputStream.write(string.getBytes());
        outputStream.write(string2.length());
        outputStream.write(string2.getBytes());
        int n2 = inputStream.read();
        if (n2 != 1 && n2 != 5) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Invalid response from SOCKS5 server (").append(n2).append(") ").append(string3).append(":").append(n))));
        }
        if (inputStream.read() != 0) {
            throw new IOException("Invalid username/password for SOCKS5 server");
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("SocksProxySocket[addr=").append(this.getInetAddress()).append(",port=").append(this.getPort()).append(",localport=").append(this.getLocalPort()).append("]")));
    }

    public static SocksProxySocket connectViaSocks5Proxy(String string, int n, String string2, int n2, String string3, String string4) throws UnknownHostException, IOException {
        return SocksProxySocket.connectViaSocks5Proxy(string, n, string2, n2, false, string3, string4);
    }
}

