/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.openssh.DSAKeyInfo;
import com.sshtools.j2ssh.openssh.PEMReader;
import com.sshtools.j2ssh.openssh.PEMWriter;
import com.sshtools.j2ssh.openssh.RSAKeyInfo;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;

public class OpenSSHPrivateKeyFormat
implements SshPrivateKeyFormat {
    public String getFormatType() {
        return "OpenSSH-PrivateKey";
    }

    public String toString() {
        return this.getFormatType();
    }

    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            byte[] byArray2 = pEMReader.decryptPayload(string);
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            if ("DSA PRIVATE KEY".equals(pEMReader.getType())) {
                DSAKeyInfo dSAKeyInfo = DSAKeyInfo.getDSAKeyInfo(simpleASNReader);
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-dss");
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getP());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getQ());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getG());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getX());
                byte[] byArray3 = byteArrayWriter.toByteArray();
                return byArray3;
            }
            if ("RSA PRIVATE KEY".equals(pEMReader.getType())) {
                RSAKeyInfo rSAKeyInfo = RSAKeyInfo.getRSAKeyInfo(simpleASNReader);
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-rsa");
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPublicExponent());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getModulus());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPrivateExponent());
                byte[] byArray4 = byteArrayWriter.toByteArray();
                return byArray4;
            }
            throw new InvalidSshKeyException("Unsupported type: ".concat(String.valueOf(String.valueOf(pEMReader.getType()))));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems: ".concat(String.valueOf(String.valueOf(generalSecurityException))));
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems: ".concat(String.valueOf(String.valueOf(iOException))));
        }
    }

    public byte[] encryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            byte[] byArray2;
            Object object;
            Object object2;
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            PEMWriter pEMWriter = new PEMWriter();
            if ("ssh-dss".equals(string2)) {
                object2 = byteArrayReader.readBigInteger();
                object = byteArrayReader.readBigInteger();
                BigInteger bigInteger = byteArrayReader.readBigInteger();
                BigInteger bigInteger2 = byteArrayReader.readBigInteger();
                DSAKeyInfo dSAKeyInfo = new DSAKeyInfo((BigInteger)object2, (BigInteger)object, bigInteger, bigInteger2, BigInteger.ZERO);
                SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
                DSAKeyInfo.writeDSAKeyInfo(simpleASNWriter, dSAKeyInfo);
                byArray2 = simpleASNWriter.toByteArray();
                pEMWriter.setType("DSA PRIVATE KEY");
            } else if ("ssh-rsa".equals(string2)) {
                object2 = byteArrayReader.readBigInteger();
                object = byteArrayReader.readBigInteger();
                BigInteger bigInteger = byteArrayReader.readBigInteger();
                RSAKeyInfo rSAKeyInfo = new RSAKeyInfo((BigInteger)object, bigInteger, (BigInteger)object2, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
                SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
                RSAKeyInfo.writeRSAKeyInfo(simpleASNWriter, rSAKeyInfo);
                byArray2 = simpleASNWriter.toByteArray();
                pEMWriter.setType("RSA PRIVATE KEY");
            } else {
                throw new InvalidSshKeyException("Unsupported J2SSH algorithm: ".concat(String.valueOf(String.valueOf(string2))));
            }
            pEMWriter.setPayload(byArray2);
            pEMWriter.encryptPayload(byArray2, string);
            object2 = new StringWriter();
            pEMWriter.write((Writer)object2);
            object = ((StringWriter)object2).toString().getBytes("US-ASCII");
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems: ".concat(String.valueOf(String.valueOf(generalSecurityException))));
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems: ".concat(String.valueOf(String.valueOf(iOException))));
        }
    }

    public boolean isFormatted(byte[] byArray) {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean isPassphraseProtected(byte[] byArray) {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            boolean bl = pEMReader.getHeader().containsKey("DEK-Info");
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = true;
            return bl;
        }
    }

    public boolean supportsAlgorithm(String string) {
        return "ssh-dss".equals(string) || "ssh-rsa".equals(string);
    }
}

