/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private List deniedHosts;
    private Map allowedHosts;
    private String knownhosts;
    private boolean hostFileWriteable;
    private boolean expectEndElement;
    private String currentElement;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$HostKeyVerification;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractKnownHostsKeyVerification(String string) throws InvalidHostFileException {
        InputStream inputStream;
        block17: {
            File file;
            this.deniedHosts = new ArrayList();
            this.allowedHosts = new HashMap();
            this.expectEndElement = false;
            this.currentElement = null;
            inputStream = null;
            if (string == null) break block17;
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission(string, "read"));
            }
            if ((file = new File(string)).exists()) {
                String string2;
                inputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    String string3 = (String)stringTokenizer.nextElement();
                    String string4 = (String)stringTokenizer.nextElement();
                    String string5 = (String)stringTokenizer.nextElement();
                    SshPublicKey sshPublicKey = SshKeyPairFactory.decodePublicKey(Base64.decode(string5));
                    if (string3.indexOf(",") > -1) {
                        string3 = string3.substring(0, string3.indexOf(","));
                    }
                    this.allowedHosts.put(string3, sshPublicKey);
                }
                bufferedReader.close();
                this.hostFileWriteable = file.canWrite();
            } else {
                file.getParentFile().mkdirs();
                if (file.createNewFile()) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(this.toString().getBytes());
                    fileOutputStream.close();
                    this.hostFileWriteable = true;
                } else {
                    this.hostFileWriteable = false;
                }
            }
            if (!this.hostFileWriteable) {
                log.warn((Object)"Host file is not writeable.");
            }
            this.knownhosts = string;
        }
        Object var12_14 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (AccessControlException accessControlException) {
                log.warn((Object)"Not enough permission to load a hosts file, so just creating an empty list");
                Object var12_15 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                throw new InvalidHostFileException("Could not open or read ".concat(String.valueOf(String.valueOf(string))));
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onDeniedHost(String var1) throws TransportProtocolException;

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String string, SshPublicKey sshPublicKey, boolean bl) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Allowing ").append(string).append(" with fingerprint ").append(sshPublicKey.getFingerprint()))));
        }
        this.allowedHosts.put(string, sshPublicKey);
        if (bl) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public List deniedHosts() {
        return this.deniedHosts;
    }

    public void removeAllowedHost(String string) {
        this.allowedHosts.remove(string);
    }

    public void removeDeniedHost(String string) {
        for (int i = this.deniedHosts.size() - 1; i >= 0; --i) {
            String string2 = (String)this.deniedHosts.get(i);
            if (!string2.equals(string)) continue;
            this.deniedHosts.remove(i);
        }
    }

    public void denyHost(String string, boolean bl) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.valueOf(String.valueOf(string)).concat(" is denied access"));
        }
        if (!this.deniedHosts.contains(string)) {
            this.deniedHosts.add(string);
        }
        if (bl) {
            this.saveHostFile();
        }
    }

    public boolean verifyHost(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
        String string2 = sshPublicKey.getFingerprint();
        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Verifying ").append(string).append(" host key"))));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Fingerprint: ".concat(String.valueOf(String.valueOf(string2))));
        }
        if (this.deniedHosts.contains(string)) {
            this.onDeniedHost(string);
            return false;
        }
        Iterator iterator = this.allowedHosts.keySet().iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), ",");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.equalsIgnoreCase(string)) continue;
                SshPublicKey sshPublicKey2 = (SshPublicKey)this.allowedHosts.get(string);
                if (sshPublicKey.equals(sshPublicKey2)) {
                    return true;
                }
                this.onHostKeyMismatch(string, sshPublicKey2, sshPublicKey);
                return this.checkFingerprint(string, string2);
            }
        }
        this.onUnknownHost(string, sshPublicKey);
        return this.checkFingerprint(string, string2);
    }

    private boolean checkFingerprint(String string, String string2) {
        SshPublicKey sshPublicKey = (SshPublicKey)this.allowedHosts.get(string);
        return sshPublicKey != null && sshPublicKey.getFingerprint().compareToIgnoreCase(string2) == 0;
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info((Object)"Saving ".concat(String.valueOf(String.valueOf(defaultHostFile))));
        try {
            File file = new File(this.knownhosts);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to ".concat(String.valueOf(String.valueOf(this.knownhosts))));
        }
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.allowedHosts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SshPublicKey sshPublicKey = (SshPublicKey)entry.getValue();
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(entry.getKey().toString()))).append(" ").append(sshPublicKey.getAlgorithmName()).append(" ").append(Base64.encodeBytes(sshPublicKey.getEncoded(), true)).append("\n"))))));
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$HostKeyVerification == null ? (class$com$sshtools$j2ssh$transport$HostKeyVerification = AbstractKnownHostsKeyVerification.class$("com.sshtools.j2ssh.transport.HostKeyVerification")) : class$com$sshtools$j2ssh$transport$HostKeyVerification));
    }
}

