/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    public ConsoleKnownHostsKeyVerification() throws InvalidHostFileException {
        super(new File(System.getProperty("user.home"), String.valueOf(String.valueOf(new StringBuffer(".ssh").append(File.separator).append("known_hosts")))).getAbsolutePath());
    }

    public ConsoleKnownHostsKeyVerification(String string) throws InvalidHostFileException {
        super(string);
    }

    public void onDeniedHost(String string) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Access to the host ").append(string).append(" is denied from this system"))));
    }

    public void onHostKeyMismatch(String string, SshPublicKey sshPublicKey, SshPublicKey sshPublicKey2) {
        try {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("The host key supplied by ").append(string).append(" is: ").append(sshPublicKey2.getFingerprint()))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("The current allowed key for ").append(string).append(" is: ").append(sshPublicKey.getFingerprint()))));
            this.getResponse(string, sshPublicKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onUnknownHost(String string, SshPublicKey sshPublicKey) {
        try {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("The host ").append(string).append(" is currently unknown to the system"))));
            System.out.println("The host key fingerprint is: ".concat(String.valueOf(String.valueOf(sshPublicKey.getFingerprint()))));
            this.getResponse(string, sshPublicKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getResponse(String string, SshPublicKey sshPublicKey) throws IOException, InvalidHostFileException {
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (!(string2.equalsIgnoreCase("YES") || string2.equalsIgnoreCase("NO") || string2.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable())) {
            String string3;
            String string4 = string3 = this.isHostFileWriteable() ? "Yes|No|Always" : "Yes|No";
            if (!this.isHostFileWriteable()) {
                System.out.println("Always option disabled, host file is not writeable");
            }
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("Do you want to allow this host key? [").append(string3).append("]: "))));
            string2 = bufferedReader.readLine();
        }
        if (string2.equalsIgnoreCase("YES")) {
            this.allowHost(string, sshPublicKey, false);
        }
        if (string2.equalsIgnoreCase("NO")) {
            System.out.println("Cannot continue without a valid host key");
            System.exit(1);
        }
        if (string2.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable()) {
            this.allowHost(string, sshPublicKey, true);
        }
    }
}

