/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCipherFactory {
    private static Map ciphers;
    private static String defaultCipher;
    private static Log log;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$SshAPIConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc;

    protected SshCipherFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCipher() {
        return defaultCipher;
    }

    public static List getSupportedCiphers() {
        ArrayList arrayList = new ArrayList(ciphers.keySet());
        ((AbstractCollection)arrayList).remove(defaultCipher);
        arrayList.add(0, defaultCipher);
        return arrayList;
    }

    public static SshCipher newInstance(String string) throws AlgorithmNotSupportedException {
        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Creating new ").append(string).append(" cipher instance"))));
        try {
            SshCipher sshCipher = (SshCipher)((Class)ciphers.get(string)).newInstance();
            return sshCipher;
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported!"));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory == null ? (class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory = SshCipherFactory.class$("com.sshtools.j2ssh.transport.cipher.SshCipherFactory")) : class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory));
        ciphers = new HashMap();
        log.info((Object)"Loading supported cipher algorithms");
        ciphers.put("3des-cbc", class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc == null ? (class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc = SshCipherFactory.class$("com.sshtools.j2ssh.transport.cipher.TripleDesCbc")) : class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc);
        ciphers.put("blowfish-cbc", class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc == null ? (class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc = SshCipherFactory.class$("com.sshtools.j2ssh.transport.cipher.BlowfishCbc")) : class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshCipherFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration)) {
                object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshCipherFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration);
                List list = object.getCipherExtensions();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                    String string = extensionAlgorithm.getAlgorithmName();
                    if (ciphers.containsKey(extensionAlgorithm.getAlgorithmName())) {
                        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Standard cipher ").append(string).append(" is being overidden by ").append(extensionAlgorithm.getImplementationClass()))));
                    } else {
                        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(extensionAlgorithm.getAlgorithmName()))).append(" cipher is implemented by ").append(extensionAlgorithm.getImplementationClass()))));
                    }
                    try {
                        ciphers.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        log.error((Object)"Could not locate ".concat(String.valueOf(String.valueOf(extensionAlgorithm.getImplementationClass()))));
                    }
                }
                defaultCipher = object.getDefaultCipher();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultCipher == null || !ciphers.containsKey(defaultCipher)) {
            log.debug((Object)"The default cipher is not set! using first in list");
            object = ciphers.keySet().iterator();
            defaultCipher = (String)object.next();
        }
    }
}

