/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhInit;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhReply;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DhGroup1Sha1
extends SshKeyExchange {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1 == null ? (class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1 = DhGroup1Sha1.class$("com.sshtools.j2ssh.transport.kex.DhGroup1Sha1")) : class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1));
    private BigInteger e = null;
    private BigInteger f = null;
    private static BigInteger g = new BigInteger("2");
    private static BigInteger p = new BigInteger(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1});
    private BigInteger x = null;
    private BigInteger y = null;
    private String clientId;
    private String serverId;
    private byte[] clientKexInit;
    private byte[] serverKexInit;
    private KeyPairGenerator dhKeyPairGen;
    private KeyAgreement dhKeyAgreement;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply;

    protected void onInit() throws IOException {
        this.messageStore.registerMessage(30, class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit == null ? (class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit = DhGroup1Sha1.class$("com.sshtools.j2ssh.transport.kex.SshMsgKexDhInit")) : class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit);
        this.messageStore.registerMessage(31, class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply == null ? (class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply = DhGroup1Sha1.class$("com.sshtools.j2ssh.transport.kex.SshMsgKexDhReply")) : class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply);
        try {
            this.dhKeyPairGen = KeyPairGenerator.getInstance("DH");
            this.dhKeyAgreement = KeyAgreement.getInstance("DH");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException(noSuchAlgorithmException.getMessage());
        }
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws IOException {
        Object object;
        Object object2;
        log.info((Object)"Starting client side key exchange.");
        this.clientId = string;
        this.serverId = string2;
        this.clientKexInit = byArray;
        this.serverKexInit = byArray2;
        try {
            object2 = new DHParameterSpec(p, g);
            this.dhKeyPairGen.initialize((AlgorithmParameterSpec)object2);
            object = this.dhKeyPairGen.generateKeyPair();
            this.dhKeyAgreement.init(((KeyPair)object).getPrivate());
            this.x = ((DHPrivateKey)((KeyPair)object).getPrivate()).getX();
            this.e = ((DHPublicKey)((KeyPair)object).getPublic()).getY();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AlgorithmOperationException("Failed to generate DH value");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AlgorithmOperationException("Failed to generate DH value");
        }
        object2 = new SshMsgKexDhInit(this.e);
        try {
            this.transport.sendMessage((SshMessage)object2, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initailaztion message");
        }
        object = new int[1];
        object[0] = 31;
        SshMsgKexDhReply sshMsgKexDhReply = (SshMsgKexDhReply)this.transport.readMessage((int[])object);
        this.hostKey = sshMsgKexDhReply.getHostKey();
        this.signature = sshMsgKexDhReply.getSignature();
        this.f = sshMsgKexDhReply.getF();
        this.secret = this.f.modPow(this.x, p);
        this.calculateExchangeHash();
    }

    public void performServerExchange(String string, String string2, byte[] byArray, byte[] byArray2, SshPrivateKey sshPrivateKey) throws IOException {
        try {
            Object object;
            Object object2;
            this.clientId = string;
            this.serverId = string2;
            this.clientKexInit = byArray;
            this.serverKexInit = byArray2;
            try {
                object2 = new DHParameterSpec(p, g);
                this.dhKeyPairGen.initialize((AlgorithmParameterSpec)object2);
                object = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(((KeyPair)object).getPrivate());
                this.y = ((DHPrivateKey)((KeyPair)object).getPrivate()).getX();
                this.f = ((DHPublicKey)((KeyPair)object).getPublic()).getY();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new AlgorithmOperationException("Failed to generate DH y value");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new AlgorithmOperationException("Failed to generate DH y value");
            }
            object2 = new int[1];
            object2[0] = 30;
            object = (SshMsgKexDhInit)this.transport.readMessage((int[])object2);
            this.e = ((SshMsgKexDhInit)object).getE();
            this.secret = this.e.modPow(this.y, p);
            this.hostKey = sshPrivateKey.getPublicKey().getEncoded();
            this.calculateExchangeHash();
            this.signature = sshPrivateKey.generateSignature(this.exchangeHash);
            SshMsgKexDhReply sshMsgKexDhReply = new SshMsgKexDhReply(this.hostKey, this.f, this.signature);
            this.transport.sendMessage(sshMsgKexDhReply, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException(sshException.getMessage());
        }
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        Hash hash;
        try {
            hash = new Hash("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

