/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class SshKeyGenerator {
    private static String filename = null;
    private static String type = "dsa";
    private static int bits = 1024;
    private static boolean useGUI;
    private static boolean guiAvailable;
    private static boolean toOpenSSH;
    private static boolean toSECSH;
    private static boolean changePass;

    public void generateKeyPair(String string, int n, String string2, String string3, String string4) throws IOException {
        System.out.println("****Sshtools.com SSH Key Pair Generator****");
        String string5 = string;
        if (string5.equalsIgnoreCase("DSA")) {
            string5 = "ssh-dss";
        }
        if (string5.equalsIgnoreCase("RSA")) {
            string5 = "ssh-rsa";
        }
        final SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string5);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Generating ").append(String.valueOf(n)).append(" bit ").append(string5).append(" key pair"))));
        SshThread sshThread = new SshThread(new Runnable(){

            public void run() {
                sshKeyPair.generate(bits);
            }
        }, "Key generator", true);
        sshThread.start();
        while (sshThread.isAlive()) {
            System.out.print(".");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Creating Public Key file ").append(string2).append(".pub"))));
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.create(sshKeyPair.getPublicKey(), new SECSHPublicKeyFormat(string3, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(n)))).append("-bit ").append(string)))));
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(String.valueOf(string2)).concat(".pub"));
        fileOutputStream.write(sshPublicKeyFile.getBytes());
        fileOutputStream.close();
        System.out.println("Generating Private Key file ".concat(String.valueOf(String.valueOf(string2))));
        if (string4 == null) {
            string4 = SshKeyGenerator.promptForPassphrase(true);
        }
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.create(sshKeyPair.getPrivateKey(), string4, new SshtoolsPrivateKeyFormat(string3, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(n)))).append("-bit ").append(string)))));
        fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(sshPrivateKeyFile.getBytes());
        fileOutputStream.close();
    }

    public static void main(String[] stringArray) {
        block14: {
            try {
                SshKeyGenerator.processCommandLine(stringArray);
                FileHandler fileHandler = new FileHandler("ssh-keygen.log");
                fileHandler.setFormatter(new SimpleFormatter());
                Logger.getLogger("com.sshtools").setUseParentHandlers(false);
                Logger.getLogger("com.sshtools").addHandler(fileHandler);
                Logger.getLogger("com.sshtools").setLevel(Level.ALL);
                if (useGUI) {
                    Class<?> clazz = Class.forName("com.sshtools.j2ssh.keygen.Main");
                    Method method = clazz.getMethod("main", stringArray.getClass());
                    method.invoke(null, new Object[]{new String[0]});
                    break block14;
                }
                File file = new File(filename);
                if (filename == null) {
                    System.err.print("You must supply a valid file to convert!");
                    System.exit(1);
                }
                if (toOpenSSH || toSECSH) {
                    if (!file.exists()) {
                        System.err.print(String.valueOf(String.valueOf(new StringBuffer("The file ").append(file.getAbsolutePath()).append(" does not exist!"))));
                        System.exit(1);
                    }
                    try {
                        if (toOpenSSH) {
                            System.out.print(SshKeyGenerator.convertPublicKeyFile(file, new OpenSSHPublicKeyFormat()));
                        } else {
                            System.out.print(SshKeyGenerator.convertPublicKeyFile(file, new SECSHPublicKeyFormat()));
                        }
                    }
                    catch (InvalidSshKeyException invalidSshKeyException) {
                        System.err.println("The key format is invalid!");
                    }
                    catch (IOException iOException) {
                        System.err.println("An error occurs whilst reading the file ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
                    }
                    System.exit(0);
                }
                if (changePass) {
                    if (!file.exists()) {
                        System.err.print(String.valueOf(String.valueOf(new StringBuffer("The file ").append(file.getAbsolutePath()).append(" does not exist!"))));
                        System.exit(1);
                    }
                    SshKeyGenerator.changePassphrase(file);
                } else {
                    SshKeyGenerator sshKeyGenerator = new SshKeyGenerator();
                    String string = System.getProperty("user.name");
                    sshKeyGenerator.generateKeyPair(type, bits, filename, string, null);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void processCommandLine(String[] stringArray) {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-b")) {
                    bits = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-t")) {
                    type = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-p")) {
                    changePass = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-g") && guiAvailable) {
                    useGUI = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-i")) {
                    toOpenSSH = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-e")) {
                    toSECSH = true;
                    continue;
                }
                if (stringArray[i].startsWith("-")) continue;
                if (filename != null) {
                    SshKeyGenerator.printUsage();
                    System.exit(1);
                }
                filename = stringArray[i];
            }
        }
        if (!useGUI && filename == null) {
            SshKeyGenerator.printUsage();
            System.exit(0);
        }
    }

    private static void changePassphrase(File file) {
        System.out.println("Opening Private Key file ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
        try {
            System.out.println("Opening Private Key file ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
            String string = SshKeyGenerator.promptForPassphrase(false);
            String string2 = SshKeyGenerator.promptForPassphrase(true);
            SshKeyGenerator.changePassphrase(file, string, string2);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            System.err.println("The key format is invalid!");
        }
        catch (IOException iOException) {
            System.err.println("An error occurs whilst reading the file ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void changePassphrase(File file, String string, String string2) throws InvalidSshKeyException, IOException {
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(file);
        System.out.println("Saving Private Key file with new passphrase");
        sshPrivateKeyFile.changePassphrase(string, string2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(sshPrivateKeyFile.getBytes());
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public static String convertPublicKeyFile(File file, SshPublicKeyFormat sshPublicKeyFormat) throws IOException, InvalidSshKeyException {
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(file);
        sshPublicKeyFile.setFormat(sshPublicKeyFormat);
        return sshPublicKeyFile.toString();
    }

    private static void printUsage() {
        System.out.println("Usage: SshKeyGenerator [options] filename");
        System.out.println("Options:");
        System.out.println("-b bits        Number of bits in the key to create.");
        System.out.println("-e             Convert OpenSSH to IETF SECSH key file.");
        System.out.println("-i             Convert IETF SECSH to OpenSSH key file.");
        System.out.println("-t type        The type of key to create.");
        System.out.println("-p             Change the passphrase of the private key file.");
        if (guiAvailable) {
            System.out.println("-g \t\tUse GUI to create key");
        }
    }

    private static String promptForPassphrase(boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        String string2 = "";
        while (true) {
            System.out.print("Enter passphrase: ");
            string = bufferedReader.readLine();
            if (!bl) break;
            System.out.print("Confirm passphrase: ");
            string2 = bufferedReader.readLine();
            if (string.equals(string2)) {
                if (string.trim().length() != 0) break;
                System.out.print("You supplied an empty passphrase, are you sure? [Yes|No]: ");
                string2 = bufferedReader.readLine();
                if (!string2.equalsIgnoreCase("YES")) continue;
                break;
            }
            System.out.println("The passphrases supplied were not indentical! Try again");
        }
        return string;
    }

    static {
        toOpenSSH = false;
        toSECSH = false;
        changePass = false;
        try {
            Class.forName("com.sshtools.j2ssh.keygen.Main");
            guiAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

